// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EncryptionResponse extends DefinedPacket {
    private byte[] sharedSecret;
    private byte[] verifyToken;
    private EncryptionData encryptionData;

    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        sharedSecret = readArray(buf, 128);
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_19 || protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3 || buf.readBoolean()) {
            verifyToken = readArray(buf, 128);
        } else {
            encryptionData = new EncryptionData(buf.readLong(), readArray(buf));
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeArray(sharedSecret, buf);
        if (verifyToken != null) {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19 && protocolVersion <= ProtocolConstants.MINECRAFT_1_19_3) {
                buf.writeBoolean(true);
            }
            writeArray(verifyToken, buf);
        } else {
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19 && protocolVersion <= ProtocolConstants.MINECRAFT_1_19_3) {
                buf.writeBoolean(false);
            }
            buf.writeLong(encryptionData.getSalt());
            writeArray(encryptionData.getSignature(), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public static class EncryptionData {
        private final long salt;
        private final byte[] signature;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public EncryptionData(final long salt, final byte[] signature) {
            this.salt = salt;
            this.signature = signature;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public long getSalt() {
            return this.salt;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public byte[] getSignature() {
            return this.signature;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof EncryptionResponse.EncryptionData)) return false;
            final EncryptionResponse.EncryptionData other = (EncryptionResponse.EncryptionData) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            if (this.getSalt() != other.getSalt()) return false;
            if (!java.util.Arrays.equals(this.getSignature(), other.getSignature())) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof EncryptionResponse.EncryptionData;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final long $salt = this.getSalt();
            result = result * PRIME + (int) ($salt >>> 32 ^ $salt);
            result = result * PRIME + java.util.Arrays.hashCode(this.getSignature());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "EncryptionResponse.EncryptionData(salt=" + this.getSalt() + ", signature=" + java.util.Arrays.toString(this.getSignature()) + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getSharedSecret() {
        return this.sharedSecret;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EncryptionData getEncryptionData() {
        return this.encryptionData;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSharedSecret(final byte[] sharedSecret) {
        this.sharedSecret = sharedSecret;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifyToken(final byte[] verifyToken) {
        this.verifyToken = verifyToken;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setEncryptionData(final EncryptionData encryptionData) {
        this.encryptionData = encryptionData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "EncryptionResponse(sharedSecret=" + java.util.Arrays.toString(this.getSharedSecret()) + ", verifyToken=" + java.util.Arrays.toString(this.getVerifyToken()) + ", encryptionData=" + this.getEncryptionData() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EncryptionResponse() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EncryptionResponse(final byte[] sharedSecret, final byte[] verifyToken, final EncryptionData encryptionData) {
        this.sharedSecret = sharedSecret;
        this.verifyToken = verifyToken;
        this.encryptionData = encryptionData;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof EncryptionResponse)) return false;
        final EncryptionResponse other = (EncryptionResponse) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!java.util.Arrays.equals(this.getSharedSecret(), other.getSharedSecret())) return false;
        if (!java.util.Arrays.equals(this.getVerifyToken(), other.getVerifyToken())) return false;
        final java.lang.Object this$encryptionData = this.getEncryptionData();
        final java.lang.Object other$encryptionData = other.getEncryptionData();
        if (this$encryptionData == null ? other$encryptionData != null : !this$encryptionData.equals(other$encryptionData)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof EncryptionResponse;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + java.util.Arrays.hashCode(this.getSharedSecret());
        result = result * PRIME + java.util.Arrays.hashCode(this.getVerifyToken());
        final java.lang.Object $encryptionData = this.getEncryptionData();
        result = result * PRIME + ($encryptionData == null ? 43 : $encryptionData.hashCode());
        return result;
    }
}
