// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class EncryptionRequest extends DefinedPacket {
    private String serverId;
    private byte[] publicKey;
    private byte[] verifyToken;
    private boolean shouldAuthenticate;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        serverId = readString(buf);
        publicKey = readArray(buf);
        verifyToken = readArray(buf);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
            shouldAuthenticate = buf.readBoolean();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(serverId, buf);
        writeArray(publicKey, buf);
        writeArray(verifyToken, buf);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) {
            buf.writeBoolean(shouldAuthenticate);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getServerId() {
        return this.serverId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getPublicKey() {
        return this.publicKey;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isShouldAuthenticate() {
        return this.shouldAuthenticate;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setServerId(final String serverId) {
        this.serverId = serverId;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPublicKey(final byte[] publicKey) {
        this.publicKey = publicKey;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setVerifyToken(final byte[] verifyToken) {
        this.verifyToken = verifyToken;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShouldAuthenticate(final boolean shouldAuthenticate) {
        this.shouldAuthenticate = shouldAuthenticate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "EncryptionRequest(serverId=" + this.getServerId() + ", publicKey=" + java.util.Arrays.toString(this.getPublicKey()) + ", verifyToken=" + java.util.Arrays.toString(this.getVerifyToken()) + ", shouldAuthenticate=" + this.isShouldAuthenticate() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EncryptionRequest() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public EncryptionRequest(final String serverId, final byte[] publicKey, final byte[] verifyToken, final boolean shouldAuthenticate) {
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.verifyToken = verifyToken;
        this.shouldAuthenticate = shouldAuthenticate;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof EncryptionRequest)) return false;
        final EncryptionRequest other = (EncryptionRequest) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.isShouldAuthenticate() != other.isShouldAuthenticate()) return false;
        final java.lang.Object this$serverId = this.getServerId();
        final java.lang.Object other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) return false;
        if (!java.util.Arrays.equals(this.getPublicKey(), other.getPublicKey())) return false;
        if (!java.util.Arrays.equals(this.getVerifyToken(), other.getVerifyToken())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof EncryptionRequest;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + (this.isShouldAuthenticate() ? 79 : 97);
        final java.lang.Object $serverId = this.getServerId();
        result = result * PRIME + ($serverId == null ? 43 : $serverId.hashCode());
        result = result * PRIME + java.util.Arrays.hashCode(this.getPublicKey());
        result = result * PRIME + java.util.Arrays.hashCode(this.getVerifyToken());
        return result;
    }
}
