// Generated by delombok at Tue Oct 21 21:24:10 UTC 2025
package net.md_5.bungee.protocol.channel;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;

/**
 * This class hold a netty channel initializer that calls the given
 * {@link ChannelAcceptor}.
 *
 * Use {@link BungeeChannelInitializer#create(ChannelAcceptor)} to create a new
 * instance.
 * <p>
 * Please note that this API is unsafe and doesn't provide any guarantees about
 * the stability of the channel pipeline or the API itself. Use at your own
 * risk.
 */
public abstract class BungeeChannelInitializer {
    public abstract ChannelAcceptor getChannelAcceptor();

    public abstract ChannelInitializer<Channel> getChannelInitializer();

    /**
     * Creates a new instance of BungeeChannelInitializer
     *
     * @param acceptor the {@link ChannelAcceptor} that will accept the channel
     * and initializer the pipeline
     * @return {@link BungeeChannelInitializer} containing a cached
     * {@link ChannelInitializer} that will call the acceptor
     */
    public static BungeeChannelInitializer create(ChannelAcceptor acceptor) {
        return new BungeeChannelInitializer() {
            private final ChannelAcceptor channelAcceptor = acceptor;
            // cache the ChannelInitializer
            private final ChannelInitializer<Channel> channelInitializer = new ChannelInitializer<Channel>() {
                @Override
                protected void initChannel(Channel channel) throws Exception {
                    if (!getChannelAcceptor().accept(channel)) {
                        channel.close();
                    }
                }
            };
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ChannelAcceptor getChannelAcceptor() {
                return this.channelAcceptor;
            }
            @java.lang.SuppressWarnings("all")
            @lombok.Generated
            public ChannelInitializer<Channel> getChannelInitializer() {
                return this.channelInitializer;
            }
        };
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    private BungeeChannelInitializer() {
    }
}
