// Generated by delombok at Sat Oct 04 04:46:56 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.util.Either;

public class ServerLinks extends DefinedPacket {
    private Link[] links;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        int len = readVarInt(buf);
        links = new Link[len];
        for (int i = 0; i < len; i++) {
            Either<Integer, BaseComponent> type;
            if (buf.readBoolean()) {
                type = Either.left(readVarInt(buf));
            } else {
                type = Either.right(readBaseComponent(buf, protocolVersion));
            }
            String url = readString(buf);
            links[i] = new Link(type, url);
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeVarInt(links.length, buf);
        for (Link link : links) {
            Either<Integer, BaseComponent> type = link.getType();
            if (type.isLeft()) {
                buf.writeBoolean(true);
                writeVarInt(type.getLeft(), buf);
            } else {
                buf.writeBoolean(false);
                writeBaseComponent(type.getRight(), buf, protocolVersion);
            }
            writeString(link.getUrl(), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public static class Link {
        private final Either<Integer, BaseComponent> type;
        private final String url;

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Link(final Either<Integer, BaseComponent> type, final String url) {
            this.type = type;
            this.url = url;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public Either<Integer, BaseComponent> getType() {
            return this.type;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public String getUrl() {
            return this.url;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public boolean equals(final java.lang.Object o) {
            if (o == this) return true;
            if (!(o instanceof ServerLinks.Link)) return false;
            final ServerLinks.Link other = (ServerLinks.Link) o;
            if (!other.canEqual((java.lang.Object) this)) return false;
            final java.lang.Object this$type = this.getType();
            final java.lang.Object other$type = other.getType();
            if (this$type == null ? other$type != null : !this$type.equals(other$type)) return false;
            final java.lang.Object this$url = this.getUrl();
            final java.lang.Object other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) return false;
            return true;
        }

        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        protected boolean canEqual(final java.lang.Object other) {
            return other instanceof ServerLinks.Link;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public int hashCode() {
            final int PRIME = 59;
            int result = 1;
            final java.lang.Object $type = this.getType();
            result = result * PRIME + ($type == null ? 43 : $type.hashCode());
            final java.lang.Object $url = this.getUrl();
            result = result * PRIME + ($url == null ? 43 : $url.hashCode());
            return result;
        }

        @java.lang.Override
        @java.lang.SuppressWarnings("all")
        @lombok.Generated
        public java.lang.String toString() {
            return "ServerLinks.Link(type=" + this.getType() + ", url=" + this.getUrl() + ")";
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Link[] getLinks() {
        return this.links;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLinks(final Link[] links) {
        this.links = links;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ServerLinks(links=" + java.util.Arrays.deepToString(this.getLinks()) + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerLinks() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ServerLinks(final Link[] links) {
        this.links = links;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ServerLinks)) return false;
        final ServerLinks other = (ServerLinks) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!java.util.Arrays.deepEquals(this.getLinks(), other.getLinks())) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ServerLinks;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + java.util.Arrays.deepHashCode(this.getLinks());
        return result;
    }
}
