// Generated by delombok at Sun Oct 26 00:53:19 UTC 2025
package net.md_5.bungee.module;

import com.google.common.io.ByteStreams;
import com.google.common.io.Files;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;

public class JenkinsModuleSource implements ModuleSource {
    @Override
    public void retrieve(ModuleSpec module, ModuleVersion version) {
        ProxyServer.getInstance().getLogger().info("Attempting to Jenkins download module " + module.getName() + " v" + version.getBuild());
        try {
            URL website = new URL("https://hub.spigotmc.org/jenkins/job/BungeeCord/" + version.getBuild() + "/artifact/module/" + module.getName().replace('_', '-') + "/target/" + module.getName() + ".jar");
            URLConnection con = website.openConnection();
            // 15 second timeout at various stages
            con.setConnectTimeout(15000);
            con.setReadTimeout(15000);
            Files.write(ByteStreams.toByteArray(con.getInputStream()), module.getFile());
            ProxyServer.getInstance().getLogger().info("Download complete");
        } catch (IOException ex) {
            ProxyServer.getInstance().getLogger().warning("Failed to download: " + Util.exception(ex));
        }
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public JenkinsModuleSource() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof JenkinsModuleSource)) return false;
        final JenkinsModuleSource other = (JenkinsModuleSource) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof JenkinsModuleSource;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int result = 1;
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "JenkinsModuleSource()";
    }
}
