// Generated by delombok at Sun Oct 26 00:53:19 UTC 2025
package net.md_5.bungee.http;

import io.netty.channel.Channel;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import net.md_5.bungee.api.Callback;

public class HttpInitializer extends ChannelInitializer<Channel> {
    private final Callback<String> callback;
    private final boolean ssl;
    private final String host;
    private final int port;

    @Override
    protected void initChannel(Channel ch) throws Exception {
        ch.pipeline().addLast("timeout", new ReadTimeoutHandler(HttpClient.TIMEOUT, TimeUnit.MILLISECONDS));
        if (ssl) {
            SSLEngine engine = SslContextBuilder.forClient().build().newEngine(ch.alloc(), host, port);
            ch.pipeline().addLast("ssl", new SslHandler(engine));
        }
        ch.pipeline().addLast("http", new HttpClientCodec());
        ch.pipeline().addLast("handler", new HttpHandler(callback));
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public HttpInitializer(final Callback<String> callback, final boolean ssl, final String host, final int port) {
        this.callback = callback;
        this.ssl = ssl;
        this.host = host;
        this.port = port;
    }
}
