/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.context.StringRange;
import com.mojang.brigadier.suggestion.Suggestion;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.channel.Channel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.CustomClickEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.api.event.SettingsChangedEvent;
import net.md_5.bungee.api.event.TabCompleteEvent;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.entitymap.EntityMap;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientChat;
import net.md_5.bungee.protocol.packet.ClientCommand;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.CookieResponse;
import net.md_5.bungee.protocol.packet.CustomClickAction;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.LoginAcknowledged;
import net.md_5.bungee.protocol.packet.LoginPayloadResponse;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.StartConfiguration;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.UnsignedClientCommand;
import net.md_5.bungee.protocol.util.TagUtil;
import net.md_5.bungee.util.AllowedCharacters;

public class UpstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;

    public UpstreamBridge(ProxyServer bungee, UserConnection con) {
        this.bungee = bungee;
        this.con = con;
        con.getTabListHandler().onConnect();
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.con.disconnect(Util.exception((Throwable)t));
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        PlayerDisconnectEvent event = new PlayerDisconnectEvent((ProxiedPlayer)this.con);
        this.bungee.getPluginManager().callEvent((Event)event);
        this.con.getTabListHandler().onDisconnect();
        BungeeCord.getInstance().removeConnection(this.con);
        if (this.con.getServer() != null) {
            this.con.getServer().disconnect("Quitting");
        }
    }

    @Override
    public void writabilityChanged(ChannelWrapper channel) throws Exception {
        if (this.con.getServer() != null) {
            Channel server = this.con.getServer().getCh().getHandle();
            if (channel.getHandle().isWritable()) {
                server.config().setAutoRead(true);
            } else {
                server.config().setAutoRead(false);
            }
        }
    }

    @Override
    public boolean shouldHandle(PacketWrapper packet) throws Exception {
        return this.con.getServer() != null || packet.packet instanceof PluginMessage || packet.packet instanceof CookieResponse || packet.packet instanceof LoginPayloadResponse;
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        ServerConnection server = this.con.getServer();
        if (server != null && server.isConnected()) {
            Protocol serverEncode = server.getCh().getEncodeProtocol();
            if (packet.protocol != serverEncode) {
                return;
            }
            EntityMap rewrite = this.con.getEntityRewrite();
            if (rewrite != null && serverEncode == Protocol.GAME) {
                rewrite.rewriteServerbound(packet.buf, this.con.getClientEntityId(), this.con.getServerEntityId(), this.con.getPendingConnection().getVersion());
            }
            server.getCh().write(packet);
        }
    }

    public void handle(KeepAlive alive) throws Exception {
        ServerConnection.KeepAliveData keepAliveData = this.con.getServer().getKeepAlives().peek();
        if (keepAliveData == null || alive.getRandomId() != keepAliveData.getId()) {
            throw CancelSendSignal.INSTANCE;
        }
        Preconditions.checkState((keepAliveData == this.con.getServer().getKeepAlives().poll() ? 1 : 0) != 0, (Object)"keepalive queue mismatch");
        int newPing = (int)(System.currentTimeMillis() - keepAliveData.getTime());
        this.con.getTabListHandler().onPingChange(newPing);
        this.con.setPing(newPing);
    }

    public void handle(Chat chat) throws Exception {
        String message = this.handleChat(chat.getMessage());
        if (message != null) {
            chat.setMessage(message);
            this.con.getServer().unsafe().sendPacket((DefinedPacket)chat);
        }
        throw CancelSendSignal.INSTANCE;
    }

    public void handle(ClientChat chat) throws Exception {
        this.handleChat(chat.getMessage());
    }

    public void handle(ClientCommand command) throws Exception {
        this.handleChat("/" + command.getCommand());
    }

    public void handle(UnsignedClientCommand command) throws Exception {
        this.handleChat("/" + command.getCommand());
    }

    private String handleChat(String message) {
        int length = message.length();
        for (int index = 0; index < length; ++index) {
            char c = message.charAt(index);
            if (AllowedCharacters.isChatAllowedCharacter(c)) continue;
            this.con.disconnect(this.bungee.getTranslation("illegal_chat_characters", new Object[]{Util.unicode((char)c)}));
            throw CancelSendSignal.INSTANCE;
        }
        ChatEvent chatEvent = new ChatEvent((Connection)this.con, (Connection)this.con.getServer(), message);
        if (!((ChatEvent)this.bungee.getPluginManager().callEvent((Event)chatEvent)).isCancelled()) {
            message = chatEvent.getMessage();
            if (!chatEvent.isCommand() || !this.bungee.getPluginManager().dispatchCommand((CommandSender)this.con, message.substring(1))) {
                return message;
            }
        }
        throw CancelSendSignal.INSTANCE;
    }

    public void handle(TabCompleteRequest tabComplete) throws Exception {
        int lastSpace;
        ArrayList suggestions = new ArrayList();
        boolean isRegisteredCommand = false;
        boolean isCommand = tabComplete.getCursor().startsWith("/");
        if (isCommand) {
            isRegisteredCommand = this.bungee.getPluginManager().dispatchCommand((CommandSender)this.con, tabComplete.getCursor().substring(1), suggestions);
        }
        TabCompleteEvent tabCompleteEvent = new TabCompleteEvent((Connection)this.con, (Connection)this.con.getServer(), tabComplete.getCursor(), suggestions);
        this.bungee.getPluginManager().callEvent((Event)tabCompleteEvent);
        if (tabCompleteEvent.isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        List results = tabCompleteEvent.getSuggestions();
        if (!results.isEmpty()) {
            if (this.con.getPendingConnection().getVersion() < 393) {
                this.con.unsafe().sendPacket((DefinedPacket)new TabCompleteResponse(results));
            } else {
                int start = tabComplete.getCursor().lastIndexOf(32) + 1;
                int end = tabComplete.getCursor().length();
                StringRange range = StringRange.between((int)start, (int)end);
                LinkedList<Suggestion> brigadier = new LinkedList<Suggestion>();
                for (String s : results) {
                    brigadier.add(new Suggestion(range, s));
                }
                this.con.unsafe().sendPacket((DefinedPacket)new TabCompleteResponse(tabComplete.getTransactionId(), new Suggestions(range, brigadier)));
            }
            throw CancelSendSignal.INSTANCE;
        }
        if (isRegisteredCommand) {
            throw CancelSendSignal.INSTANCE;
        }
        if (isCommand && this.con.getPendingConnection().getVersion() < 393 && (lastSpace = tabComplete.getCursor().lastIndexOf(32)) == -1) {
            this.con.setLastCommandTabbed(tabComplete.getCursor().substring(1));
        }
    }

    public void handle(ClientSettings settings) throws Exception {
        this.con.setSettings(settings);
        SettingsChangedEvent settingsEvent = new SettingsChangedEvent((ProxiedPlayer)this.con);
        this.bungee.getPluginManager().callEvent((Event)settingsEvent);
    }

    public void handle(PluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("BungeeCord") || pluginMessage.getTag().equals("bungeecord:main")) {
            throw CancelSendSignal.INSTANCE;
        }
        if (BungeeCord.getInstance().config.isForgeSupport()) {
            if (pluginMessage.getTag().equals("FML") && pluginMessage.getStream().readUnsignedByte() == 1) {
                throw CancelSendSignal.INSTANCE;
            }
            if (pluginMessage.getTag().equals("FML|HS")) {
                this.con.getForgeClientHandler().handle(pluginMessage);
                throw CancelSendSignal.INSTANCE;
            }
            if (this.con.getServer() != null && !this.con.getServer().isForgeServer() && pluginMessage.getData().length > Short.MAX_VALUE) {
                throw CancelSendSignal.INSTANCE;
            }
        }
        PluginMessageEvent event = new PluginMessageEvent((Connection)this.con, (Connection)this.con.getServer(), pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (((PluginMessageEvent)this.bungee.getPluginManager().callEvent((Event)event)).isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
        this.con.getPendingConnection().relayMessage(pluginMessage);
    }

    public void handle(LoginAcknowledged loginAcknowledged) throws Exception {
        this.configureServer();
    }

    public void handle(StartConfiguration startConfiguration) throws Exception {
        this.configureServer();
    }

    private void configureServer() {
        ChannelWrapper ch = this.con.getServer().getCh();
        if (ch.getDecodeProtocol() == Protocol.LOGIN) {
            ch.setDecodeProtocol(Protocol.CONFIGURATION);
            ch.write(new LoginAcknowledged());
            ch.setEncodeProtocol(Protocol.CONFIGURATION);
            this.con.getServer().sendQueuedPackets();
            throw CancelSendSignal.INSTANCE;
        }
    }

    public void handle(CookieResponse cookieResponse) throws Exception {
        this.con.getPendingConnection().handle(cookieResponse);
    }

    public void handle(LoginPayloadResponse loginPayloadResponse) throws Exception {
        this.con.getPendingConnection().handle(loginPayloadResponse);
    }

    public void handle(CustomClickAction customClickAction) throws Exception {
        CustomClickEvent event = new CustomClickEvent((ProxiedPlayer)this.con, customClickAction.getId(), TagUtil.toJson((TypedTag)customClickAction.getData()));
        if (((CustomClickEvent)this.bungee.getPluginManager().callEvent((Event)event)).isCancelled()) {
            throw CancelSendSignal.INSTANCE;
        }
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] -> UpstreamBridge";
    }
}

