// Generated by delombok at Sat Oct 04 04:46:56 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class Chat extends DefinedPacket {
    private static final UUID EMPTY_UUID = new UUID(0L, 0L);
    private String message;
    private byte position;
    private UUID sender;

    public Chat(String message) {
        this(message, (byte) 0);
    }

    public Chat(String message, byte position) {
        this(message, position, EMPTY_UUID);
    }

    public Chat(String message, byte position, UUID sender) {
        this.message = message;
        this.position = position;
        this.sender = sender == null ? EMPTY_UUID : sender;
    }

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        message = readString(buf, (direction == ProtocolConstants.Direction.TO_CLIENT) ? 262144 : (protocolVersion >= ProtocolConstants.MINECRAFT_1_11 ? 256 : 100));
        if (direction == ProtocolConstants.Direction.TO_CLIENT) {
            position = buf.readByte();
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
                sender = readUUID(buf);
            }
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(message, buf, (direction == ProtocolConstants.Direction.TO_CLIENT) ? 262144 : (protocolVersion >= ProtocolConstants.MINECRAFT_1_11 ? 256 : 100));
        if (direction == ProtocolConstants.Direction.TO_CLIENT) {
            buf.writeByte(position);
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_16) {
                writeUUID(sender, buf);
            }
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getMessage() {
        return this.message;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getPosition() {
        return this.position;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public UUID getSender() {
        return this.sender;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMessage(final String message) {
        this.message = message;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setPosition(final byte position) {
        this.position = position;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSender(final UUID sender) {
        this.sender = sender;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "Chat(message=" + this.getMessage() + ", position=" + this.getPosition() + ", sender=" + this.getSender() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Chat() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof Chat)) return false;
        final Chat other = (Chat) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getPosition() != other.getPosition()) return false;
        final java.lang.Object this$message = this.getMessage();
        final java.lang.Object other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) return false;
        final java.lang.Object this$sender = this.getSender();
        final java.lang.Object other$sender = other.getSender();
        if (this$sender == null ? other$sender != null : !this$sender.equals(other$sender)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof Chat;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getPosition();
        final java.lang.Object $message = this.getMessage();
        result = result * PRIME + ($message == null ? 43 : $message.hashCode());
        final java.lang.Object $sender = this.getSender();
        result = result * PRIME + ($sender == null ? 43 : $sender.hashCode());
        return result;
    }
}
