// Generated by delombok at Sat Oct 04 04:46:56 UTC 2025
package net.md_5.bungee.protocol.packet;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.data.ChatChain;
import net.md_5.bungee.protocol.data.SeenMessages;

public class ClientCommand extends DefinedPacket {
    private String command;
    private long timestamp;
    private long salt;
    private Map<String, byte[]> signatures;
    private boolean signedPreview;
    private ChatChain chain;
    private SeenMessages seenMessages;
    private byte checksum;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        command = readString(buf, (protocolVersion >= ProtocolConstants.MINECRAFT_1_20_5) ? 32767 : 256);
        timestamp = buf.readLong();
        salt = buf.readLong();
        int cnt = readVarInt(buf);
        Preconditions.checkArgument(cnt <= 8, "Too many signatures");
        signatures = new HashMap<>(cnt);
        for (int i = 0; i < cnt; i++) {
            String name = readString(buf, 16);
            byte[] signature;
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
                signature = new byte[256];
                buf.readBytes(signature);
            } else {
                signature = readArray(buf);
            }
            signatures.put(name, signature);
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            signedPreview = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
            seenMessages = new SeenMessages();
            seenMessages.read(buf, direction, protocolVersion);
        } else if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1) {
            chain = new ChatChain();
            chain.read(buf, direction, protocolVersion);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_5) {
            checksum = buf.readByte();
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(command, buf);
        buf.writeLong(timestamp);
        buf.writeLong(salt);
        writeVarInt(signatures.size(), buf);
        for (Map.Entry<String, byte[]> entry : signatures.entrySet()) {
            writeString(entry.getKey(), buf);
            if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
                buf.writeBytes(entry.getValue());
            } else {
                writeArray(entry.getValue(), buf);
            }
        }
        if (protocolVersion < ProtocolConstants.MINECRAFT_1_19_3) {
            buf.writeBoolean(signedPreview);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_3) {
            seenMessages.write(buf, direction, protocolVersion);
        } else if (protocolVersion >= ProtocolConstants.MINECRAFT_1_19_1) {
            chain.write(buf, direction, protocolVersion);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_5) {
            buf.writeByte(checksum);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getCommand() {
        return this.command;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getTimestamp() {
        return this.timestamp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public long getSalt() {
        return this.salt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public Map<String, byte[]> getSignatures() {
        return this.signatures;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isSignedPreview() {
        return this.signedPreview;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ChatChain getChain() {
        return this.chain;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SeenMessages getSeenMessages() {
        return this.seenMessages;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getChecksum() {
        return this.checksum;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setCommand(final String command) {
        this.command = command;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setTimestamp(final long timestamp) {
        this.timestamp = timestamp;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSalt(final long salt) {
        this.salt = salt;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSignatures(final Map<String, byte[]> signatures) {
        this.signatures = signatures;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSignedPreview(final boolean signedPreview) {
        this.signedPreview = signedPreview;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChain(final ChatChain chain) {
        this.chain = chain;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeenMessages(final SeenMessages seenMessages) {
        this.seenMessages = seenMessages;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChecksum(final byte checksum) {
        this.checksum = checksum;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ClientCommand(command=" + this.getCommand() + ", timestamp=" + this.getTimestamp() + ", salt=" + this.getSalt() + ", signatures=" + this.getSignatures() + ", signedPreview=" + this.isSignedPreview() + ", chain=" + this.getChain() + ", seenMessages=" + this.getSeenMessages() + ", checksum=" + this.getChecksum() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClientCommand() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClientCommand(final String command, final long timestamp, final long salt, final Map<String, byte[]> signatures, final boolean signedPreview, final ChatChain chain, final SeenMessages seenMessages, final byte checksum) {
        this.command = command;
        this.timestamp = timestamp;
        this.salt = salt;
        this.signatures = signatures;
        this.signedPreview = signedPreview;
        this.chain = chain;
        this.seenMessages = seenMessages;
        this.checksum = checksum;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ClientCommand)) return false;
        final ClientCommand other = (ClientCommand) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getTimestamp() != other.getTimestamp()) return false;
        if (this.getSalt() != other.getSalt()) return false;
        if (this.isSignedPreview() != other.isSignedPreview()) return false;
        if (this.getChecksum() != other.getChecksum()) return false;
        final java.lang.Object this$command = this.getCommand();
        final java.lang.Object other$command = other.getCommand();
        if (this$command == null ? other$command != null : !this$command.equals(other$command)) return false;
        final java.lang.Object this$signatures = this.getSignatures();
        final java.lang.Object other$signatures = other.getSignatures();
        if (this$signatures == null ? other$signatures != null : !this$signatures.equals(other$signatures)) return false;
        final java.lang.Object this$chain = this.getChain();
        final java.lang.Object other$chain = other.getChain();
        if (this$chain == null ? other$chain != null : !this$chain.equals(other$chain)) return false;
        final java.lang.Object this$seenMessages = this.getSeenMessages();
        final java.lang.Object other$seenMessages = other.getSeenMessages();
        if (this$seenMessages == null ? other$seenMessages != null : !this$seenMessages.equals(other$seenMessages)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ClientCommand;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final long $timestamp = this.getTimestamp();
        result = result * PRIME + (int) ($timestamp >>> 32 ^ $timestamp);
        final long $salt = this.getSalt();
        result = result * PRIME + (int) ($salt >>> 32 ^ $salt);
        result = result * PRIME + (this.isSignedPreview() ? 79 : 97);
        result = result * PRIME + this.getChecksum();
        final java.lang.Object $command = this.getCommand();
        result = result * PRIME + ($command == null ? 43 : $command.hashCode());
        final java.lang.Object $signatures = this.getSignatures();
        result = result * PRIME + ($signatures == null ? 43 : $signatures.hashCode());
        final java.lang.Object $chain = this.getChain();
        result = result * PRIME + ($chain == null ? 43 : $chain.hashCode());
        final java.lang.Object $seenMessages = this.getSeenMessages();
        result = result * PRIME + ($seenMessages == null ? 43 : $seenMessages.hashCode());
        return result;
    }
}
