// Generated by delombok at Sat Oct 04 04:46:56 UTC 2025
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ClientSettings extends DefinedPacket {
    private String locale;
    private byte viewDistance;
    private int chatFlags;
    private boolean chatColours;
    private byte difficulty;
    private byte skinParts;
    private int mainHand;
    private boolean disableTextFiltering;
    private boolean allowServerListing;
    private ParticleStatus particleStatus;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        locale = readString(buf, 16);
        viewDistance = buf.readByte();
        chatFlags = protocolVersion >= ProtocolConstants.MINECRAFT_1_9 ? DefinedPacket.readVarInt(buf) : buf.readUnsignedByte();
        chatColours = buf.readBoolean();
        skinParts = buf.readByte();
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_9) {
            mainHand = DefinedPacket.readVarInt(buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_17) {
            disableTextFiltering = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_18) {
            allowServerListing = buf.readBoolean();
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_2) {
            particleStatus = ParticleStatus.values()[readVarInt(buf)];
        }
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        writeString(locale, buf);
        buf.writeByte(viewDistance);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_9) {
            DefinedPacket.writeVarInt(chatFlags, buf);
        } else {
            buf.writeByte(chatFlags);
        }
        buf.writeBoolean(chatColours);
        buf.writeByte(skinParts);
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_9) {
            DefinedPacket.writeVarInt(mainHand, buf);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_17) {
            buf.writeBoolean(disableTextFiltering);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_18) {
            buf.writeBoolean(allowServerListing);
        }
        if (protocolVersion >= ProtocolConstants.MINECRAFT_1_21_2) {
            writeVarInt(particleStatus.ordinal(), buf);
        }
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }


    public enum ParticleStatus {
        ALL, DECREASED, MINIMAL;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getLocale() {
        return this.locale;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getViewDistance() {
        return this.viewDistance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getChatFlags() {
        return this.chatFlags;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isChatColours() {
        return this.chatColours;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getDifficulty() {
        return this.difficulty;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getSkinParts() {
        return this.skinParts;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int getMainHand() {
        return this.mainHand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isDisableTextFiltering() {
        return this.disableTextFiltering;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean isAllowServerListing() {
        return this.allowServerListing;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ParticleStatus getParticleStatus() {
        return this.particleStatus;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setLocale(final String locale) {
        this.locale = locale;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setViewDistance(final byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChatFlags(final int chatFlags) {
        this.chatFlags = chatFlags;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setChatColours(final boolean chatColours) {
        this.chatColours = chatColours;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDifficulty(final byte difficulty) {
        this.difficulty = difficulty;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSkinParts(final byte skinParts) {
        this.skinParts = skinParts;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setMainHand(final int mainHand) {
        this.mainHand = mainHand;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setDisableTextFiltering(final boolean disableTextFiltering) {
        this.disableTextFiltering = disableTextFiltering;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setAllowServerListing(final boolean allowServerListing) {
        this.allowServerListing = allowServerListing;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setParticleStatus(final ParticleStatus particleStatus) {
        this.particleStatus = particleStatus;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ClientSettings(locale=" + this.getLocale() + ", viewDistance=" + this.getViewDistance() + ", chatFlags=" + this.getChatFlags() + ", chatColours=" + this.isChatColours() + ", difficulty=" + this.getDifficulty() + ", skinParts=" + this.getSkinParts() + ", mainHand=" + this.getMainHand() + ", disableTextFiltering=" + this.isDisableTextFiltering() + ", allowServerListing=" + this.isAllowServerListing() + ", particleStatus=" + this.getParticleStatus() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClientSettings() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ClientSettings(final String locale, final byte viewDistance, final int chatFlags, final boolean chatColours, final byte difficulty, final byte skinParts, final int mainHand, final boolean disableTextFiltering, final boolean allowServerListing, final ParticleStatus particleStatus) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatFlags = chatFlags;
        this.chatColours = chatColours;
        this.difficulty = difficulty;
        this.skinParts = skinParts;
        this.mainHand = mainHand;
        this.disableTextFiltering = disableTextFiltering;
        this.allowServerListing = allowServerListing;
        this.particleStatus = particleStatus;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ClientSettings)) return false;
        final ClientSettings other = (ClientSettings) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getViewDistance() != other.getViewDistance()) return false;
        if (this.getChatFlags() != other.getChatFlags()) return false;
        if (this.isChatColours() != other.isChatColours()) return false;
        if (this.getDifficulty() != other.getDifficulty()) return false;
        if (this.getSkinParts() != other.getSkinParts()) return false;
        if (this.getMainHand() != other.getMainHand()) return false;
        if (this.isDisableTextFiltering() != other.isDisableTextFiltering()) return false;
        if (this.isAllowServerListing() != other.isAllowServerListing()) return false;
        final java.lang.Object this$locale = this.getLocale();
        final java.lang.Object other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) return false;
        final java.lang.Object this$particleStatus = this.getParticleStatus();
        final java.lang.Object other$particleStatus = other.getParticleStatus();
        if (this$particleStatus == null ? other$particleStatus != null : !this$particleStatus.equals(other$particleStatus)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ClientSettings;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getViewDistance();
        result = result * PRIME + this.getChatFlags();
        result = result * PRIME + (this.isChatColours() ? 79 : 97);
        result = result * PRIME + this.getDifficulty();
        result = result * PRIME + this.getSkinParts();
        result = result * PRIME + this.getMainHand();
        result = result * PRIME + (this.isDisableTextFiltering() ? 79 : 97);
        result = result * PRIME + (this.isAllowServerListing() ? 79 : 97);
        final java.lang.Object $locale = this.getLocale();
        result = result * PRIME + ($locale == null ? 43 : $locale.hashCode());
        final java.lang.Object $particleStatus = this.getParticleStatus();
        result = result * PRIME + ($particleStatus == null ? 43 : $particleStatus.hashCode());
        return result;
    }
}
