// Generated by delombok at Sat Nov 01 00:44:59 UTC 2025
package net.md_5.bungee.api.chat;

/**
 * This component processes a target selector into a pre-formatted set of
 * discovered names.
 * <br>
 * Multiple targets may be obtained, and with commas separating each one and a
 * final "and" for the last target. The resulting format cannot be overwritten.
 * This includes all styling from team prefixes, insertions, click events, and
 * hover events.
 * <br>
 * These values are filled in by the server-side implementation.
 * <br>
 * As of 1.12.2, a bug ( MC-56373 ) prevents full usage within hover events.
 */
public final class SelectorComponent extends BaseComponent {
    /**
     * An entity target selector (@p, @a, @r, @e, or @s) and, optionally,
     * selector arguments (e.g. @e[r=10,type=Creeper]).
     */
    private String selector;
    /**
     * The separator of multiple selected entities.
     * <br>
     * The default is {@code {"color": "gray", "text": ", "}}.
     */
    private BaseComponent separator;

    /**
     * Creates a selector component from the original to clone it.
     *
     * @param original the original for the new selector component
     */
    public SelectorComponent(SelectorComponent original) {
        super(original);
        setSelector(original.getSelector());
        setSeparator(original.getSeparator());
    }

    /**
     * Creates a selector component from the selector
     *
     * @param selector the selector as a String
     */
    public SelectorComponent(String selector) {
        setSelector(selector);
    }

    @Override
    public SelectorComponent duplicate() {
        return new SelectorComponent(this);
    }

    @Override
    protected void toPlainText(StringVisitor builder) {
        builder.append(this.selector);
        super.toPlainText(builder);
    }

    @Override
    protected void toLegacyText(StringVisitor builder) {
        addFormat(builder);
        builder.append(this.selector);
        super.toLegacyText(builder);
    }

    /**
     * An entity target selector (@p, @a, @r, @e, or @s) and, optionally,
     * selector arguments (e.g. @e[r=10,type=Creeper]).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public String getSelector() {
        return this.selector;
    }

    /**
     * The separator of multiple selected entities.
     * <br>
     * The default is {@code {"color": "gray", "text": ", "}}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public BaseComponent getSeparator() {
        return this.separator;
    }

    /**
     * An entity target selector (@p, @a, @r, @e, or @s) and, optionally,
     * selector arguments (e.g. @e[r=10,type=Creeper]).
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSelector(final String selector) {
        this.selector = selector;
    }

    /**
     * The separator of multiple selected entities.
     * <br>
     * The default is {@code {"color": "gray", "text": ", "}}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setSeparator(final BaseComponent separator) {
        this.separator = separator;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "SelectorComponent(selector=" + this.getSelector() + ", separator=" + this.getSeparator() + ")";
    }

    /**
     * Creates a new {@code SelectorComponent} instance.
     *
     * @param selector An entity target selector (@p, @a, @r, @e, or @s) and, optionally,
     * selector arguments (e.g. @e[r=10,type=Creeper]).
     * @param separator The separator of multiple selected entities.
     * <br>
     * The default is {@code {"color": "gray", "text": ", "}}.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public SelectorComponent(final String selector, final BaseComponent separator) {
        this.selector = selector;
        this.separator = separator;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof SelectorComponent)) return false;
        final SelectorComponent other = (SelectorComponent) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (!super.equals(o)) return false;
        final java.lang.Object this$selector = this.getSelector();
        final java.lang.Object other$selector = other.getSelector();
        if (this$selector == null ? other$selector != null : !this$selector.equals(other$selector)) return false;
        final java.lang.Object this$separator = this.getSeparator();
        final java.lang.Object other$separator = other.getSeparator();
        if (this$separator == null ? other$separator != null : !this$separator.equals(other$separator)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof SelectorComponent;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = super.hashCode();
        final java.lang.Object $selector = this.getSelector();
        result = result * PRIME + ($selector == null ? 43 : $selector.hashCode());
        final java.lang.Object $separator = this.getSeparator();
        result = result * PRIME + ($separator == null ? 43 : $separator.hashCode());
        return result;
    }
}
