// Generated by delombok at Sat Nov 01 00:44:59 UTC 2025
package net.md_5.bungee.api.chat;

import java.awt.Color;
import net.md_5.bungee.api.ChatColor;

/**
 * Represents a style that may be applied to a {@link BaseComponent}.
 */
public final class ComponentStyle implements Cloneable {
    /**
     * The color of this style.
     * <p>
     * <b>Warning: This should be a color, not formatting code (ie,
     * {@link ChatColor#color} should not be null).</b>
     */
    private ChatColor color;
    /**
     * The shadow color of this style.
     */
    private Color shadowColor;
    /**
     * The font of this style.
     */
    private String font;
    /**
     * Whether this style is bold.
     */
    private Boolean bold;
    /**
     * Whether this style is italic.
     */
    private Boolean italic;
    /**
     * Whether this style is underlined.
     */
    private Boolean underlined;
    /**
     * Whether this style is strikethrough.
     */
    private Boolean strikethrough;
    /**
     * Whether this style is obfuscated.
     */
    private Boolean obfuscated;

    /**
     * Returns the color of this style. May return null.
     *
     * @return the color of this style, or null if default color
     */
    public ChatColor getColor() {
        return color;
    }

    /**
     * Returns whether or not this style has a color set.
     *
     * @return whether a color is set
     */
    public boolean hasColor() {
        return (color != null);
    }

    /**
     * Returns the shadow color of this style. May return null.
     *
     * @return the shadow color of this style, or null if default color
     */
    public Color getShadowColor() {
        return shadowColor;
    }

    /**
     * Returns whether or not this style has a shadow color set.
     *
     * @return whether a shadow color is set
     */
    public boolean hasShadowColor() {
        return (shadowColor != null);
    }

    /**
     * Returns the font of this style. May return null.
     *
     * @return the font of this style, or null if default font
     */
    public String getFont() {
        return font;
    }

    /**
     * Returns whether or not this style has a font set.
     *
     * @return whether a font is set
     */
    public boolean hasFont() {
        return (font != null);
    }

    /**
     * Returns whether this style is bold.
     *
     * @return whether the style is bold
     */
    public boolean isBold() {
        return (bold != null) && bold.booleanValue();
    }

    /**
     * Returns whether this style is bold. May return null.
     *
     * @return whether the style is bold, or null if not set
     */
    public Boolean isBoldRaw() {
        return bold;
    }

    /**
     * Returns whether this style is italic. May return null.
     *
     * @return whether the style is italic
     */
    public boolean isItalic() {
        return (italic != null) && italic.booleanValue();
    }

    /**
     * Returns whether this style is italic. May return null.
     *
     * @return whether the style is italic, or null if not set
     */
    public Boolean isItalicRaw() {
        return italic;
    }

    /**
     * Returns whether this style is underlined.
     *
     * @return whether the style is underlined
     */
    public boolean isUnderlined() {
        return (underlined != null) && underlined.booleanValue();
    }

    /**
     * Returns whether this style is underlined. May return null.
     *
     * @return whether the style is underlined, or null if not set
     */
    public Boolean isUnderlinedRaw() {
        return underlined;
    }

    /**
     * Returns whether this style is strikethrough
     *
     * @return whether the style is strikethrough
     */
    public boolean isStrikethrough() {
        return (strikethrough != null) && strikethrough.booleanValue();
    }

    /**
     * Returns whether this style is strikethrough. May return null.
     *
     * @return whether the style is strikethrough, or null if not set
     */
    public Boolean isStrikethroughRaw() {
        return strikethrough;
    }

    /**
     * Returns whether this style is obfuscated.
     *
     * @return whether the style is obfuscated
     */
    public boolean isObfuscated() {
        return (obfuscated != null) && obfuscated.booleanValue();
    }

    /**
     * Returns whether this style is obfuscated. May return null.
     *
     * @return whether the style is obfuscated, or null if not set
     */
    public Boolean isObfuscatedRaw() {
        return obfuscated;
    }

    /**
     * Returns whether this style has no formatting explicitly set.
     *
     * @return true if no value is set, false if at least one is set
     */
    public boolean isEmpty() {
        return color == null && shadowColor == null && font == null && bold == null && italic == null && underlined == null && strikethrough == null && obfuscated == null;
    }

    @Override
    public ComponentStyle clone() {
        return new ComponentStyle(color, shadowColor, font, bold, italic, underlined, strikethrough, obfuscated);
    }

    /**
     * Get a new {@link ComponentStyleBuilder}.
     *
     * @return the builder
     */
    public static ComponentStyleBuilder builder() {
        return new ComponentStyleBuilder();
    }

    /**
     * Get a new {@link ComponentStyleBuilder} with values initialized to the
     * style values of the supplied {@link ComponentStyle}.
     *
     * @param other the component style whose values to copy into the builder
     * @return the builder
     */
    public static ComponentStyleBuilder builder(ComponentStyle other) {
        return new ComponentStyleBuilder().color(other.color).shadowColor(other.shadowColor).font(other.font).bold(other.bold).italic(other.italic).underlined(other.underlined).strikethrough(other.strikethrough).obfuscated(other.obfuscated);
    }

    /**
     * The color of this style.
     * <p>
     * <b>Warning: This should be a color, not formatting code (ie,
     * {@link ChatColor#color} should not be null).</b>
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setColor(final ChatColor color) {
        this.color = color;
    }

    /**
     * The shadow color of this style.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setShadowColor(final Color shadowColor) {
        this.shadowColor = shadowColor;
    }

    /**
     * The font of this style.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setFont(final String font) {
        this.font = font;
    }

    /**
     * Whether this style is bold.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setBold(final Boolean bold) {
        this.bold = bold;
    }

    /**
     * Whether this style is italic.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setItalic(final Boolean italic) {
        this.italic = italic;
    }

    /**
     * Whether this style is underlined.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setUnderlined(final Boolean underlined) {
        this.underlined = underlined;
    }

    /**
     * Whether this style is strikethrough.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setStrikethrough(final Boolean strikethrough) {
        this.strikethrough = strikethrough;
    }

    /**
     * Whether this style is obfuscated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setObfuscated(final Boolean obfuscated) {
        this.obfuscated = obfuscated;
    }

    /**
     * Creates a new {@code ComponentStyle} instance.
     *
     * @param color The color of this style.
     * <p>
     * <b>Warning: This should be a color, not formatting code (ie,
     * {@link ChatColor#color} should not be null).</b>
     * @param shadowColor The shadow color of this style.
     * @param font The font of this style.
     * @param bold Whether this style is bold.
     * @param italic Whether this style is italic.
     * @param underlined Whether this style is underlined.
     * @param strikethrough Whether this style is strikethrough.
     * @param obfuscated Whether this style is obfuscated.
     */
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ComponentStyle(final ChatColor color, final Color shadowColor, final String font, final Boolean bold, final Boolean italic, final Boolean underlined, final Boolean strikethrough, final Boolean obfuscated) {
        this.color = color;
        this.shadowColor = shadowColor;
        this.font = font;
        this.bold = bold;
        this.italic = italic;
        this.underlined = underlined;
        this.strikethrough = strikethrough;
        this.obfuscated = obfuscated;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ComponentStyle() {
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ComponentStyle)) return false;
        final ComponentStyle other = (ComponentStyle) o;
        final java.lang.Object this$bold = this.bold;
        final java.lang.Object other$bold = other.bold;
        if (this$bold == null ? other$bold != null : !this$bold.equals(other$bold)) return false;
        final java.lang.Object this$italic = this.italic;
        final java.lang.Object other$italic = other.italic;
        if (this$italic == null ? other$italic != null : !this$italic.equals(other$italic)) return false;
        final java.lang.Object this$underlined = this.underlined;
        final java.lang.Object other$underlined = other.underlined;
        if (this$underlined == null ? other$underlined != null : !this$underlined.equals(other$underlined)) return false;
        final java.lang.Object this$strikethrough = this.strikethrough;
        final java.lang.Object other$strikethrough = other.strikethrough;
        if (this$strikethrough == null ? other$strikethrough != null : !this$strikethrough.equals(other$strikethrough)) return false;
        final java.lang.Object this$obfuscated = this.obfuscated;
        final java.lang.Object other$obfuscated = other.obfuscated;
        if (this$obfuscated == null ? other$obfuscated != null : !this$obfuscated.equals(other$obfuscated)) return false;
        final java.lang.Object this$color = this.getColor();
        final java.lang.Object other$color = other.getColor();
        if (this$color == null ? other$color != null : !this$color.equals(other$color)) return false;
        final java.lang.Object this$shadowColor = this.getShadowColor();
        final java.lang.Object other$shadowColor = other.getShadowColor();
        if (this$shadowColor == null ? other$shadowColor != null : !this$shadowColor.equals(other$shadowColor)) return false;
        final java.lang.Object this$font = this.getFont();
        final java.lang.Object other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) return false;
        return true;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        final java.lang.Object $bold = this.bold;
        result = result * PRIME + ($bold == null ? 43 : $bold.hashCode());
        final java.lang.Object $italic = this.italic;
        result = result * PRIME + ($italic == null ? 43 : $italic.hashCode());
        final java.lang.Object $underlined = this.underlined;
        result = result * PRIME + ($underlined == null ? 43 : $underlined.hashCode());
        final java.lang.Object $strikethrough = this.strikethrough;
        result = result * PRIME + ($strikethrough == null ? 43 : $strikethrough.hashCode());
        final java.lang.Object $obfuscated = this.obfuscated;
        result = result * PRIME + ($obfuscated == null ? 43 : $obfuscated.hashCode());
        final java.lang.Object $color = this.getColor();
        result = result * PRIME + ($color == null ? 43 : $color.hashCode());
        final java.lang.Object $shadowColor = this.getShadowColor();
        result = result * PRIME + ($shadowColor == null ? 43 : $shadowColor.hashCode());
        final java.lang.Object $font = this.getFont();
        result = result * PRIME + ($font == null ? 43 : $font.hashCode());
        return result;
    }
}
