// Generated by delombok at Tue Oct 21 21:23:55 UTC 2025
package net.md_5.bungee.nbt.type;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.md_5.bungee.nbt.Tag;
import net.md_5.bungee.nbt.TypedTag;
import net.md_5.bungee.nbt.exception.NBTFormatException;
import net.md_5.bungee.nbt.limit.NBTLimiter;

public class ListTag implements TypedTag {
    public static final int LIST_HEADER = 12;
    //
    private List<TypedTag> value;
    private byte listType;

    @Override
    public void read(DataInput input, NBTLimiter limiter) throws IOException {
        limiter.push();
        limiter.countBytes(OBJECT_HEADER + LIST_HEADER + ARRAY_HEADER + Byte.BYTES + Integer.BYTES);
        listType = input.readByte();
        int length = input.readInt();
        if (length < 0) {
            throw new NBTFormatException("ListTag length cannot be negative");
        }
        if (listType == Tag.END && length > 0) {
            throw new NBTFormatException("Missing type in ListTag");
        }
        limiter.countBytes(length, OBJECT_REFERENCE);
        List<TypedTag> tagList = new ArrayList<>(length);
        for (int i = 0; i < length; i++) {
            tagList.add(Tag.readById(listType, input, limiter));
        }
        limiter.pop();
        value = tagList;
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(value, "list value cannot be null");
        if (listType == Tag.END && !value.isEmpty()) {
            throw new NBTFormatException("Missing type in ListTag");
        }
        output.writeByte(listType);
        output.writeInt(value.size());
        for (TypedTag tag : value) {
            if (tag.getId() != listType) {
                throw new NBTFormatException("ListTag type mismatch");
            }
            tag.write(output);
        }
    }

    @Override
    public byte getId() {
        return Tag.LIST;
    }

    public TypedTag get(int index) {
        return value.get(index);
    }

    public int size() {
        return value.size();
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public List<TypedTag> getValue() {
        return this.value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public byte getListType() {
        return this.listType;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setValue(final List<TypedTag> value) {
        this.value = value;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public void setListType(final byte listType) {
        this.listType = listType;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public boolean equals(final java.lang.Object o) {
        if (o == this) return true;
        if (!(o instanceof ListTag)) return false;
        final ListTag other = (ListTag) o;
        if (!other.canEqual((java.lang.Object) this)) return false;
        if (this.getListType() != other.getListType()) return false;
        final java.lang.Object this$value = this.getValue();
        final java.lang.Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) return false;
        return true;
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    protected boolean canEqual(final java.lang.Object other) {
        return other instanceof ListTag;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public int hashCode() {
        final int PRIME = 59;
        int result = 1;
        result = result * PRIME + this.getListType();
        final java.lang.Object $value = this.getValue();
        result = result * PRIME + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public java.lang.String toString() {
        return "ListTag(value=" + this.getValue() + ", listType=" + this.getListType() + ")";
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ListTag() {
    }

    @java.lang.SuppressWarnings("all")
    @lombok.Generated
    public ListTag(final List<TypedTag> value, final byte listType) {
        this.value = value;
        this.listType = listType;
    }
}
