/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.FastThreadLocalThread;
import java.util.concurrent.atomic.AtomicInteger;

public class FastThreadLocal<V>
extends ThreadLocal<V> {
    static final Object EMPTY = new Object();
    private static final AtomicInteger NEXT_INDEX = new AtomicInteger(0);
    private final ThreadLocal<V> fallback = new ThreadLocal<V>(){

        @Override
        protected V initialValue() {
            return FastThreadLocal.this.initialValue();
        }
    };
    private final int index = NEXT_INDEX.getAndIncrement();

    public FastThreadLocal() {
        if (this.index < 0) {
            NEXT_INDEX.decrementAndGet();
            throw new IllegalStateException("Maximal number (2147483647) of FastThreadLocal exceeded");
        }
    }

    @Override
    public void set(V value) {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof FastThreadLocalThread)) {
            this.fallback.set(value);
            return;
        }
        FastThreadLocalThread fastThread = (FastThreadLocalThread)thread;
        Object[] lookup = fastThread.lookup;
        if (this.index >= lookup.length) {
            lookup = fastThread.expandArray(this.index);
        }
        lookup[this.index] = value;
    }

    @Override
    public void remove() {
        Thread thread = Thread.currentThread();
        if (!(thread instanceof FastThreadLocalThread)) {
            this.fallback.remove();
            return;
        }
        Object[] lookup = ((FastThreadLocalThread)thread).lookup;
        if (this.index >= lookup.length) {
            return;
        }
        lookup[this.index] = EMPTY;
    }

    @Override
    public V get() {
        Object v;
        Thread thread = Thread.currentThread();
        if (!(thread instanceof FastThreadLocalThread)) {
            return this.fallback.get();
        }
        FastThreadLocalThread fastThread = (FastThreadLocalThread)thread;
        Object[] lookup = fastThread.lookup;
        if (this.index >= lookup.length) {
            v = this.initialValue();
            lookup = fastThread.expandArray(this.index);
            lookup[this.index] = v;
        } else {
            v = lookup[this.index];
            if (v == EMPTY) {
                v = this.initialValue();
                lookup[this.index] = v;
            }
        }
        return (V)v;
    }
}

