/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.log;

import com.google.common.base.Charsets;
import java.beans.ConstructorProperties;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggingOutputStream
extends ByteArrayOutputStream {
    private static final String separator = System.getProperty("line.separator");
    private final Logger logger;
    private final Level level;

    @Override
    public void flush() throws IOException {
        String contents = this.toString(Charsets.UTF_8.name());
        super.reset();
        if (!contents.isEmpty() && !contents.equals(separator)) {
            this.logger.logp(this.level, "", "", contents);
        }
    }

    @ConstructorProperties(value={"logger", "level"})
    public LoggingOutputStream(Logger logger, Level level) {
        this.logger = logger;
        this.level = level;
    }
}

