/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCipher;
import net.md_5.bungee.NativeCipherImpl;

public class NativeCipher
implements BungeeCipher {
    private final NativeCipherImpl nativeCipher = new NativeCipherImpl();
    private boolean forEncryption;
    private byte[] iv;
    private static boolean loaded;
    private long pointer;

    public static boolean isSupported() {
        return "Linux".equals(System.getProperty("os.name")) && "amd64".equals(System.getProperty("os.arch"));
    }

    public static boolean load() {
        if (!loaded && NativeCipher.isSupported()) {
            try (InputStream lib = BungeeCipher.class.getClassLoader().getResourceAsStream("native-cipher.so");){
                File temp = File.createTempFile("bungeecord-native-cipher", ".so");
                temp.deleteOnExit();
                try (FileOutputStream outputStream = new FileOutputStream(temp);){
                    ByteStreams.copy(lib, (OutputStream)outputStream);
                    System.load(temp.getPath());
                }
                loaded = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return loaded;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    @Override
    public void init(boolean forEncryption, SecretKey key) throws GeneralSecurityException {
        Preconditions.checkArgument(key.getEncoded().length == 16, "Invalid key size");
        if (this.pointer != 0L) {
            this.nativeCipher.free(this.pointer);
        }
        this.forEncryption = forEncryption;
        this.iv = key.getEncoded();
        this.pointer = this.nativeCipher.init(key.getEncoded());
    }

    @Override
    public void free() {
        if (this.pointer != 0L) {
            this.nativeCipher.free(this.pointer);
            this.pointer = 0L;
        }
    }

    @Override
    public void cipher(ByteBuf in, ByteBuf out) throws GeneralSecurityException {
        in.memoryAddress();
        out.memoryAddress();
        Preconditions.checkState(this.pointer != 0L, "Invalid pointer to AES key!");
        Preconditions.checkState(this.iv != null, "Invalid IV!");
        int length = in.readableBytes();
        out.ensureWritable(length);
        this.nativeCipher.cipher(this.forEncryption, this.pointer, this.iv, in.memoryAddress() + (long)in.readerIndex(), out.memoryAddress() + (long)out.writerIndex(), length);
        in.readerIndex(in.writerIndex());
        out.writerIndex(out.writerIndex() + length);
    }

    @Override
    public ByteBuf cipher(ChannelHandlerContext ctx, ByteBuf in) throws GeneralSecurityException {
        int readableBytes = in.readableBytes();
        ByteBuf heapOut = ctx.alloc().directBuffer(readableBytes);
        this.cipher(in, heapOut);
        return heapOut;
    }

    public NativeCipherImpl getNativeCipher() {
        return this.nativeCipher;
    }
}

