/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.EventLoopGroup;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.reflect.Type;
import java.net.InetSocketAddress;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import jline.UnsupportedTerminal;
import jline.console.ConsoleReader;
import jline.internal.Log;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ConnectionThrottle;
import net.md_5.bungee.Metrics;
import net.md_5.bungee.NativeCipher;
import net.md_5.bungee.PlayerInfoSerializer;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.Favicon;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ReconnectHandler;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.config.ConfigurationAdapter;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import net.md_5.bungee.api.tab.CustomTabList;
import net.md_5.bungee.chat.ComponentSerializer;
import net.md_5.bungee.command.CommandBungee;
import net.md_5.bungee.command.CommandEnd;
import net.md_5.bungee.command.CommandIP;
import net.md_5.bungee.command.CommandPerms;
import net.md_5.bungee.command.CommandReload;
import net.md_5.bungee.command.ConsoleCommandSender;
import net.md_5.bungee.conf.Configuration;
import net.md_5.bungee.conf.YamlConfig;
import net.md_5.bungee.log.BungeeLogger;
import net.md_5.bungee.log.LoggingOutputStream;
import net.md_5.bungee.module.ModuleManager;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.Protocol;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.query.RemoteQuery;
import net.md_5.bungee.scheduler.BungeeScheduler;
import net.md_5.bungee.tab.Custom;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.fusesource.jansi.AnsiConsole;

public class BungeeCord
extends ProxyServer {
    public volatile boolean isRunning;
    public final Configuration config = new Configuration();
    public ResourceBundle bundle;
    public EventLoopGroup eventLoops;
    private final Timer saveThread = new Timer("Reconnect Saver");
    private final Timer metricsThread = new Timer("Metrics Thread");
    private Collection<Channel> listeners = new HashSet<Channel>();
    private final Map<String, UserConnection> connections = new CaseInsensitiveMap<UserConnection>();
    private final ReadWriteLock connectionLock = new ReentrantReadWriteLock();
    public final PluginManager pluginManager = new PluginManager(this);
    private ReconnectHandler reconnectHandler;
    private ConfigurationAdapter configurationAdapter = new YamlConfig();
    private final Collection<String> pluginChannels = new HashSet<String>();
    private final File pluginsFolder = new File("plugins");
    private final BungeeScheduler scheduler = new BungeeScheduler();
    private ConsoleReader consoleReader;
    private final Logger logger;
    public final Gson gson = new GsonBuilder().registerTypeAdapter((Type)((Object)ServerPing.PlayerInfo.class), new PlayerInfoSerializer(5)).registerTypeAdapter((Type)((Object)Favicon.class), Favicon.getFaviconTypeAdapter()).create();
    public final Gson gsonLegacy = new GsonBuilder().registerTypeAdapter((Type)((Object)ServerPing.PlayerInfo.class), new PlayerInfoSerializer(4)).registerTypeAdapter((Type)((Object)Favicon.class), Favicon.getFaviconTypeAdapter()).create();
    private ConnectionThrottle connectionThrottle;
    private final ModuleManager moduleManager = new ModuleManager();

    public static BungeeCord getInstance() {
        return (BungeeCord)ProxyServer.getInstance();
    }

    public BungeeCord() throws IOException {
        this.getPluginManager().registerCommand(null, new CommandReload());
        this.getPluginManager().registerCommand(null, new CommandEnd());
        this.getPluginManager().registerCommand(null, new CommandIP());
        this.getPluginManager().registerCommand(null, new CommandBungee());
        this.getPluginManager().registerCommand(null, new CommandPerms());
        this.registerChannel("BungeeCord");
        try {
            this.bundle = ResourceBundle.getBundle("messages");
        }
        catch (MissingResourceException ex) {
            this.bundle = ResourceBundle.getBundle("messages", Locale.ENGLISH);
        }
        Log.setOutput(new PrintStream(ByteStreams.nullOutputStream()));
        AnsiConsole.systemInstall();
        this.consoleReader = new ConsoleReader();
        this.consoleReader.setExpandEvents(false);
        this.logger = new BungeeLogger(this);
        System.setErr(new PrintStream(new LoggingOutputStream(this.logger, Level.SEVERE), true));
        System.setOut(new PrintStream(new LoggingOutputStream(this.logger, Level.INFO), true));
        if (this.consoleReader.getTerminal() instanceof UnsupportedTerminal) {
            this.logger.info("Unable to initialize fancy terminal. To fix this on Windows, install the correct Microsoft Visual C++ 2008 Runtime");
            this.logger.info("NOTE: This error is non crucial, and BungeeCord will still function correctly! Do not bug the author about it unless you are still unable to get it working");
        }
        if (NativeCipher.load()) {
            this.logger.info("Using OpenSSL based native cipher.");
        } else {
            this.logger.info("Using standard Java JCE cipher. To enable the OpenSSL based native cipher, please make sure you are using 64 bit Ubuntu or Debian with libssl installed.");
        }
    }

    @Override
    public void start() throws Exception {
        System.setProperty("java.net.preferIPv4Stack", "true");
        System.setProperty("io.netty.selectorAutoRebuildThreshold", "0");
        ResourceLeakDetector.setEnabled(false);
        this.eventLoops = PipelineUtils.newEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty IO Thread #%1$d").build());
        File moduleDirectory = new File("modules");
        this.moduleManager.load(this, moduleDirectory);
        this.pluginManager.detectPlugins(moduleDirectory);
        this.pluginsFolder.mkdir();
        this.pluginManager.detectPlugins(this.pluginsFolder);
        this.pluginManager.loadPlugins();
        this.config.load();
        this.isRunning = true;
        this.pluginManager.enablePlugins();
        this.connectionThrottle = new ConnectionThrottle(this.config.getThrottle());
        this.startListeners();
        this.saveThread.scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                if (BungeeCord.this.getReconnectHandler() != null) {
                    BungeeCord.this.getReconnectHandler().save();
                }
            }
        }, 0L, TimeUnit.MINUTES.toMillis(5L));
        this.metricsThread.scheduleAtFixedRate((TimerTask)new Metrics(), 0L, TimeUnit.MINUTES.toMillis(10L));
    }

    public void startListeners() {
        for (final ListenerInfo info : this.config.getListeners()) {
            ChannelFutureListener listener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().info("Listening on " + info.getHost());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + info.getHost(), future.cause());
                    }
                }
            };
            ((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().channel(PipelineUtils.getServerChannel())).childAttr(PipelineUtils.LISTENER, info).childHandler(PipelineUtils.SERVER_CHILD).group(this.eventLoops).localAddress(info.getHost())).bind().addListener(listener);
            if (!info.isQueryEnabled()) continue;
            ChannelFutureListener bindListener = new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        BungeeCord.this.listeners.add(future.channel());
                        BungeeCord.this.getLogger().info("Started query on " + future.channel().localAddress());
                    } else {
                        BungeeCord.this.getLogger().log(Level.WARNING, "Could not bind to host " + future.channel().remoteAddress(), future.cause());
                    }
                }
            };
            new RemoteQuery(this, info).start(PipelineUtils.getDatagramChannel(), new InetSocketAddress(info.getHost().getAddress(), info.getQueryPort()), this.eventLoops, bindListener);
        }
    }

    public void stopListeners() {
        for (Channel listener : this.listeners) {
            this.getLogger().log(Level.INFO, "Closing listener {0}", listener);
            try {
                listener.close().syncUninterruptibly();
            }
            catch (ChannelException ex) {
                this.getLogger().severe("Could not close listen thread");
            }
        }
        this.listeners.clear();
    }

    @Override
    public void stop() {
        new Thread("Shutdown Thread"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                BungeeCord.this.isRunning = false;
                BungeeCord.this.stopListeners();
                BungeeCord.this.getLogger().info("Closing pending connections");
                BungeeCord.this.connectionLock.readLock().lock();
                try {
                    BungeeCord.this.getLogger().info("Disconnecting " + BungeeCord.this.connections.size() + " connections");
                    for (UserConnection user : BungeeCord.this.connections.values()) {
                        user.disconnect(BungeeCord.this.getTranslation("restart", new Object[0]));
                    }
                }
                finally {
                    BungeeCord.this.connectionLock.readLock().unlock();
                }
                BungeeCord.this.getLogger().info("Closing IO threads");
                BungeeCord.this.eventLoops.shutdownGracefully();
                try {
                    BungeeCord.this.eventLoops.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                if (BungeeCord.this.reconnectHandler != null) {
                    BungeeCord.this.getLogger().info("Saving reconnect locations");
                    BungeeCord.this.reconnectHandler.save();
                    BungeeCord.this.reconnectHandler.close();
                }
                BungeeCord.this.saveThread.cancel();
                BungeeCord.this.metricsThread.cancel();
                BungeeCord.this.getLogger().info("Disabling plugins");
                for (Plugin plugin : BungeeCord.this.pluginManager.getPlugins()) {
                    try {
                        plugin.onDisable();
                        for (Handler handler : plugin.getLogger().getHandlers()) {
                            handler.close();
                        }
                    }
                    catch (Throwable t) {
                        BungeeCord.this.getLogger().severe("Exception disabling plugin " + plugin.getDescription().getName());
                        t.printStackTrace();
                    }
                    BungeeCord.this.getScheduler().cancel(plugin);
                }
                BungeeCord.this.scheduler.shutdown();
                BungeeCord.this.getLogger().info("Thank you and goodbye");
                for (Handler handler : BungeeCord.this.getLogger().getHandlers()) {
                    handler.close();
                }
                System.exit(0);
            }
        }.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void broadcast(DefinedPacket packet) {
        this.connectionLock.readLock().lock();
        try {
            for (UserConnection con : this.connections.values()) {
                con.unsafe().sendPacket(packet);
            }
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public String getName() {
        return "BungeeCord";
    }

    @Override
    public String getVersion() {
        return BungeeCord.class.getPackage().getImplementationVersion() == null ? "unknown" : BungeeCord.class.getPackage().getImplementationVersion();
    }

    @Override
    public String getTranslation(String name, Object ... args) {
        String translation = "<translation '" + name + "' missing>";
        try {
            translation = MessageFormat.format(this.bundle.getString(name), args);
        }
        catch (MissingResourceException ex) {
            // empty catch block
        }
        return translation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ProxiedPlayer> getPlayers() {
        this.connectionLock.readLock().lock();
        try {
            Collection<ProxiedPlayer> collection = Collections.unmodifiableCollection(new HashSet<UserConnection>(this.connections.values()));
            return collection;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public int getOnlineCount() {
        return this.connections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxiedPlayer getPlayer(String name) {
        this.connectionLock.readLock().lock();
        try {
            ProxiedPlayer proxiedPlayer = this.connections.get(name);
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProxiedPlayer getPlayer(UUID uuid) {
        this.connectionLock.readLock().lock();
        try {
            for (ProxiedPlayer proxiedPlayer : this.connections.values()) {
                if (!proxiedPlayer.getUniqueId().equals(uuid)) continue;
                ProxiedPlayer proxiedPlayer2 = proxiedPlayer;
                return proxiedPlayer2;
            }
            ProxiedPlayer proxiedPlayer = null;
            return proxiedPlayer;
        }
        finally {
            this.connectionLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, ServerInfo> getServers() {
        return this.config.getServers();
    }

    @Override
    public ServerInfo getServerInfo(String name) {
        return this.getServers().get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.add(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterChannel(String channel) {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            this.pluginChannels.remove(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<String> getChannels() {
        Collection<String> collection = this.pluginChannels;
        synchronized (collection) {
            return Collections.unmodifiableCollection(this.pluginChannels);
        }
    }

    public PluginMessage registerChannels() {
        return new PluginMessage("REGISTER", Util.format(this.pluginChannels, "\u0000").getBytes());
    }

    @Override
    public int getProtocolVersion() {
        return Protocol.supportedVersions.get(Protocol.supportedVersions.size() - 1);
    }

    @Override
    public String getGameVersion() {
        return "1.7.9";
    }

    @Override
    public ServerInfo constructServerInfo(String name, InetSocketAddress address, String motd, boolean restricted) {
        return new BungeeServerInfo(name, address, motd, restricted);
    }

    @Override
    public CommandSender getConsole() {
        return ConsoleCommandSender.getInstance();
    }

    @Override
    public void broadcast(String message) {
        this.broadcast(TextComponent.fromLegacyText(message));
    }

    @Override
    public void broadcast(BaseComponent ... message) {
        this.getConsole().sendMessage(BaseComponent.toLegacyText(message));
        this.broadcast(new Chat(ComponentSerializer.toString(message)));
    }

    @Override
    public void broadcast(BaseComponent message) {
        this.getConsole().sendMessage(message.toLegacyText());
        this.broadcast(new Chat(ComponentSerializer.toString(message)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            this.connections.put(con.getName(), con);
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnection(UserConnection con) {
        this.connectionLock.writeLock().lock();
        try {
            this.connections.remove(con.getName());
        }
        finally {
            this.connectionLock.writeLock().unlock();
        }
    }

    @Override
    public CustomTabList customTabList(ProxiedPlayer player) {
        return new Custom(player);
    }

    @Override
    public Collection<String> getDisabledCommands() {
        return this.config.getDisabledCommands();
    }

    @Override
    public Collection<ProxiedPlayer> matchPlayer(final String partialName) {
        Preconditions.checkNotNull(partialName, "partialName");
        ProxiedPlayer exactMatch = this.getPlayer(partialName);
        if (exactMatch != null) {
            return Collections.singleton(exactMatch);
        }
        return Sets.newHashSet(Iterables.find(this.getPlayers(), new Predicate<ProxiedPlayer>(){

            @Override
            public boolean apply(ProxiedPlayer input) {
                return input.getName().toLowerCase().contains(partialName.toLowerCase());
            }
        }));
    }

    @Override
    public Configuration getConfig() {
        return this.config;
    }

    @Override
    public PluginManager getPluginManager() {
        return this.pluginManager;
    }

    @Override
    public ReconnectHandler getReconnectHandler() {
        return this.reconnectHandler;
    }

    @Override
    public void setReconnectHandler(ReconnectHandler reconnectHandler) {
        this.reconnectHandler = reconnectHandler;
    }

    @Override
    public ConfigurationAdapter getConfigurationAdapter() {
        return this.configurationAdapter;
    }

    @Override
    public void setConfigurationAdapter(ConfigurationAdapter configurationAdapter) {
        this.configurationAdapter = configurationAdapter;
    }

    @Override
    public File getPluginsFolder() {
        return this.pluginsFolder;
    }

    @Override
    public BungeeScheduler getScheduler() {
        return this.scheduler;
    }

    public ConsoleReader getConsoleReader() {
        return this.consoleReader;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    public ConnectionThrottle getConnectionThrottle() {
        return this.connectionThrottle;
    }
}

