/*
 * Decompiled with CFR 0.152.
 */
package io.netty.util.internal;

import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.PlatformDependent0;

public abstract class OneTimeTask
implements Runnable {
    private static final long nextOffset;
    private volatile OneTimeTask tail;

    final OneTimeTask next() {
        return (OneTimeTask)PlatformDependent.getObjectVolatile(this, nextOffset);
    }

    final void setNext(OneTimeTask newNext) {
        PlatformDependent.putOrderedObject(this, nextOffset, newNext);
    }

    static {
        if (PlatformDependent0.hasUnsafe()) {
            try {
                nextOffset = PlatformDependent.objectFieldOffset(OneTimeTask.class.getDeclaredField("tail"));
            }
            catch (Throwable t) {
                throw new ExceptionInInitializerError(t);
            }
        } else {
            nextOffset = -1L;
        }
    }
}

