/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import com.google.common.base.Preconditions;
import gnu.trove.map.TObjectIntMap;
import gnu.trove.map.hash.TObjectIntHashMap;
import java.beans.ConstructorProperties;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;
import net.md_5.bungee.protocol.packet.Chat;
import net.md_5.bungee.protocol.packet.ClientSettings;
import net.md_5.bungee.protocol.packet.EncryptionRequest;
import net.md_5.bungee.protocol.packet.EncryptionResponse;
import net.md_5.bungee.protocol.packet.Handshake;
import net.md_5.bungee.protocol.packet.KeepAlive;
import net.md_5.bungee.protocol.packet.Kick;
import net.md_5.bungee.protocol.packet.Login;
import net.md_5.bungee.protocol.packet.LoginRequest;
import net.md_5.bungee.protocol.packet.LoginSuccess;
import net.md_5.bungee.protocol.packet.PingPacket;
import net.md_5.bungee.protocol.packet.PlayerListItem;
import net.md_5.bungee.protocol.packet.PluginMessage;
import net.md_5.bungee.protocol.packet.Respawn;
import net.md_5.bungee.protocol.packet.ScoreboardDisplay;
import net.md_5.bungee.protocol.packet.ScoreboardObjective;
import net.md_5.bungee.protocol.packet.ScoreboardScore;
import net.md_5.bungee.protocol.packet.StatusRequest;
import net.md_5.bungee.protocol.packet.StatusResponse;
import net.md_5.bungee.protocol.packet.TabCompleteRequest;
import net.md_5.bungee.protocol.packet.TabCompleteResponse;
import net.md_5.bungee.protocol.packet.Team;

public enum Protocol {
    HANDSHAKE{
        {
            this.TO_SERVER.registerPacket(0, Handshake.class);
        }
    }
    ,
    GAME{
        {
            this.TO_CLIENT.registerPacket(0, KeepAlive.class);
            this.TO_CLIENT.registerPacket(1, Login.class);
            this.TO_CLIENT.registerPacket(2, Chat.class);
            this.TO_CLIENT.registerPacket(7, Respawn.class);
            this.TO_CLIENT.registerPacket(56, PlayerListItem.class);
            this.TO_CLIENT.registerPacket(58, TabCompleteResponse.class);
            this.TO_CLIENT.registerPacket(59, ScoreboardObjective.class);
            this.TO_CLIENT.registerPacket(60, ScoreboardScore.class);
            this.TO_CLIENT.registerPacket(61, ScoreboardDisplay.class);
            this.TO_CLIENT.registerPacket(62, Team.class);
            this.TO_CLIENT.registerPacket(63, PluginMessage.class);
            this.TO_CLIENT.registerPacket(64, Kick.class);
            this.TO_SERVER.registerPacket(0, KeepAlive.class);
            this.TO_SERVER.registerPacket(1, Chat.class);
            this.TO_SERVER.registerPacket(20, TabCompleteRequest.class);
            this.TO_SERVER.registerPacket(21, ClientSettings.class);
            this.TO_SERVER.registerPacket(23, PluginMessage.class);
        }
    }
    ,
    STATUS{
        {
            this.TO_CLIENT.registerPacket(0, StatusResponse.class);
            this.TO_CLIENT.registerPacket(1, PingPacket.class);
            this.TO_SERVER.registerPacket(0, StatusRequest.class);
            this.TO_SERVER.registerPacket(1, PingPacket.class);
        }
    }
    ,
    LOGIN{
        {
            this.TO_CLIENT.registerPacket(0, Kick.class);
            this.TO_CLIENT.registerPacket(1, EncryptionRequest.class);
            this.TO_CLIENT.registerPacket(2, LoginSuccess.class);
            this.TO_SERVER.registerPacket(0, LoginRequest.class);
            this.TO_SERVER.registerPacket(1, EncryptionResponse.class);
        }
    };

    public static final int MAX_PACKET_ID = 255;
    public static List<Integer> supportedVersions;
    public final DirectionData TO_SERVER = new DirectionData(ProtocolConstants.Direction.TO_SERVER);
    public final DirectionData TO_CLIENT = new DirectionData(ProtocolConstants.Direction.TO_CLIENT);

    static {
        supportedVersions = Arrays.asList(ProtocolConstants.MINECRAFT_1_7_2, ProtocolConstants.MINECRAFT_1_7_6, ProtocolConstants.MINECRAFT_14_11_a);
    }

    public class DirectionData {
        private final ProtocolConstants.Direction direction;
        private final TObjectIntMap<Class<? extends DefinedPacket>> packetMap = new TObjectIntHashMap<Class<? extends DefinedPacket>>(255);
        private final Class<? extends DefinedPacket>[] packetClasses = new Class[255];
        private final Constructor<? extends DefinedPacket>[] packetConstructors = new Constructor[255];

        public boolean hasPacket(int id) {
            return id < 255 && this.packetConstructors[id] != null;
        }

        public final DefinedPacket createPacket(int id) {
            if (id > 255) {
                throw new BadPacketException("Packet with id " + id + " outside of range ");
            }
            if (this.packetConstructors[id] == null) {
                throw new BadPacketException("No packet with id " + id);
            }
            try {
                return this.packetClasses[id].newInstance();
            }
            catch (ReflectiveOperationException ex) {
                throw new BadPacketException("Could not construct packet with id " + id, ex);
            }
        }

        protected final void registerPacket(int id, Class<? extends DefinedPacket> packetClass) {
            try {
                this.packetConstructors[id] = packetClass.getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new BadPacketException("No NoArgsConstructor for packet class " + packetClass);
            }
            this.packetClasses[id] = packetClass;
            this.packetMap.put(packetClass, id);
        }

        protected final void unregisterPacket(int id) {
            this.packetMap.remove(this.packetClasses[id]);
            this.packetClasses[id] = null;
            this.packetConstructors[id] = null;
        }

        final int getId(Class<? extends DefinedPacket> packet) {
            Preconditions.checkArgument(this.packetMap.containsKey(packet), "Cannot get ID for packet " + packet);
            return this.packetMap.get(packet);
        }

        @ConstructorProperties(value={"direction"})
        public DirectionData(ProtocolConstants.Direction direction) {
            this.direction = direction;
        }

        public ProtocolConstants.Direction getDirection() {
            return this.direction;
        }
    }
}

