/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.LongHashMap;
import net.minecraft.server.PlayerInstance;
import net.minecraft.server.WorldProvider;
import net.minecraft.server.WorldServer;

public class PlayerManager {
    private final WorldServer world;
    private final List managedPlayers = new ArrayList();
    private final LongHashMap c = new LongHashMap();
    private final List d = new ArrayList();
    private final int e;
    private final int[][] f = new int[][]{{1, 0}, {0, 1}, {-1, 0}, {0, -1}};

    public PlayerManager(WorldServer worldServer, int n) {
        if (n > 15) {
            throw new IllegalArgumentException("Too big view radius!");
        }
        if (n < 3) {
            throw new IllegalArgumentException("Too small view radius!");
        }
        this.e = n;
        this.world = worldServer;
    }

    public WorldServer a() {
        return this.world;
    }

    public void flush() {
        Object object = this.d.iterator();
        while (object.hasNext()) {
            PlayerInstance playerInstance = (PlayerInstance)object.next();
            playerInstance.a();
        }
        this.d.clear();
        if (this.managedPlayers.isEmpty() && !((WorldProvider)(object = this.world.worldProvider)).e()) {
            this.world.chunkProviderServer.a();
        }
    }

    private PlayerInstance a(int n, int n2, boolean bl) {
        long l = (long)n + Integer.MAX_VALUE | (long)n2 + Integer.MAX_VALUE << 32;
        PlayerInstance playerInstance = (PlayerInstance)this.c.getEntry(l);
        if (playerInstance == null && bl) {
            playerInstance = new PlayerInstance(this, n, n2);
            this.c.put(l, playerInstance);
        }
        return playerInstance;
    }

    public void flagDirty(int n, int n2, int n3) {
        int n4 = n >> 4;
        int n5 = n3 >> 4;
        PlayerInstance playerInstance = this.a(n4, n5, false);
        if (playerInstance != null) {
            playerInstance.a(n & 0xF, n2, n3 & 0xF);
        }
    }

    public void addPlayer(EntityPlayer entityPlayer) {
        int n = (int)entityPlayer.locX >> 4;
        int n2 = (int)entityPlayer.locZ >> 4;
        entityPlayer.d = entityPlayer.locX;
        entityPlayer.e = entityPlayer.locZ;
        for (int i = n - this.e; i <= n + this.e; ++i) {
            for (int j = n2 - this.e; j <= n2 + this.e; ++j) {
                this.a(i, j, true).a(entityPlayer);
            }
        }
        this.managedPlayers.add(entityPlayer);
        this.b(entityPlayer);
    }

    public void b(EntityPlayer entityPlayer) {
        int n;
        ArrayList arrayList = new ArrayList(entityPlayer.chunkCoordIntPairQueue);
        int n2 = 0;
        int n3 = this.e;
        int n4 = (int)entityPlayer.locX >> 4;
        int n5 = (int)entityPlayer.locZ >> 4;
        int n6 = 0;
        int n7 = 0;
        ChunkCoordIntPair chunkCoordIntPair = PlayerInstance.a(this.a(n4, n5, true));
        entityPlayer.chunkCoordIntPairQueue.clear();
        if (arrayList.contains(chunkCoordIntPair)) {
            entityPlayer.chunkCoordIntPairQueue.add(chunkCoordIntPair);
        }
        for (n = 1; n <= n3 * 2; ++n) {
            for (int i = 0; i < 2; ++i) {
                int[] nArray = this.f[n2++ % 4];
                for (int j = 0; j < n; ++j) {
                    chunkCoordIntPair = PlayerInstance.a(this.a(n4 + (n6 += nArray[0]), n5 + (n7 += nArray[1]), true));
                    if (!arrayList.contains(chunkCoordIntPair)) continue;
                    entityPlayer.chunkCoordIntPairQueue.add(chunkCoordIntPair);
                }
            }
        }
        n2 %= 4;
        for (n = 0; n < n3 * 2; ++n) {
            chunkCoordIntPair = PlayerInstance.a(this.a(n4 + (n6 += this.f[n2][0]), n5 + (n7 += this.f[n2][1]), true));
            if (!arrayList.contains(chunkCoordIntPair)) continue;
            entityPlayer.chunkCoordIntPairQueue.add(chunkCoordIntPair);
        }
    }

    public void removePlayer(EntityPlayer entityPlayer) {
        int n = (int)entityPlayer.d >> 4;
        int n2 = (int)entityPlayer.e >> 4;
        for (int i = n - this.e; i <= n + this.e; ++i) {
            for (int j = n2 - this.e; j <= n2 + this.e; ++j) {
                PlayerInstance playerInstance = this.a(i, j, false);
                if (playerInstance == null) continue;
                playerInstance.b(entityPlayer);
            }
        }
        this.managedPlayers.remove(entityPlayer);
    }

    private boolean a(int n, int n2, int n3, int n4, int n5) {
        int n6 = n - n3;
        int n7 = n2 - n4;
        if (n6 < -n5 || n6 > n5) {
            return false;
        }
        return n7 >= -n5 && n7 <= n5;
    }

    public void movePlayer(EntityPlayer entityPlayer) {
        int n = (int)entityPlayer.locX >> 4;
        int n2 = (int)entityPlayer.locZ >> 4;
        double d = entityPlayer.d - entityPlayer.locX;
        double d2 = entityPlayer.e - entityPlayer.locZ;
        double d3 = d * d + d2 * d2;
        if (d3 < 64.0) {
            return;
        }
        int n3 = (int)entityPlayer.d >> 4;
        int n4 = (int)entityPlayer.e >> 4;
        int n5 = this.e;
        int n6 = n - n3;
        int n7 = n2 - n4;
        if (n6 == 0 && n7 == 0) {
            return;
        }
        for (int i = n - n5; i <= n + n5; ++i) {
            for (int j = n2 - n5; j <= n2 + n5; ++j) {
                PlayerInstance playerInstance;
                if (!this.a(i, j, n3, n4, n5)) {
                    this.a(i, j, true).a(entityPlayer);
                }
                if (this.a(i - n6, j - n7, n, n2, n5) || (playerInstance = this.a(i - n6, j - n7, false)) == null) continue;
                playerInstance.b(entityPlayer);
            }
        }
        this.b(entityPlayer);
        entityPlayer.d = entityPlayer.locX;
        entityPlayer.e = entityPlayer.locZ;
    }

    public boolean a(EntityPlayer entityPlayer, int n, int n2) {
        PlayerInstance playerInstance = this.a(n, n2, false);
        return playerInstance == null ? false : PlayerInstance.b(playerInstance).contains(entityPlayer) && !entityPlayer.chunkCoordIntPairQueue.contains(PlayerInstance.a(playerInstance));
    }

    public static int getFurthestViewableBlock(int n) {
        return n * 16 - 16;
    }

    static /* synthetic */ WorldServer a(PlayerManager playerManager) {
        return playerManager.world;
    }

    static /* synthetic */ LongHashMap b(PlayerManager playerManager) {
        return playerManager.c;
    }

    static /* synthetic */ List c(PlayerManager playerManager) {
        return playerManager.d;
    }
}

