/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.Block;
import net.minecraft.server.BlockFurnace;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.IInventory;
import net.minecraft.server.Item;
import net.minecraft.server.ItemHoe;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemSword;
import net.minecraft.server.ItemTool;
import net.minecraft.server.Material;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NBTTagList;
import net.minecraft.server.RecipesFurnace;
import net.minecraft.server.TileEntity;

public class TileEntityFurnace
extends TileEntity
implements IInventory {
    private ItemStack[] items = new ItemStack[3];
    public int burnTime = 0;
    public int ticksForCurrentFuel = 0;
    public int cookTime = 0;

    public int getSize() {
        return this.items.length;
    }

    public ItemStack getItem(int n) {
        return this.items[n];
    }

    public ItemStack splitStack(int n, int n2) {
        if (this.items[n] != null) {
            if (this.items[n].count <= n2) {
                ItemStack itemStack = this.items[n];
                this.items[n] = null;
                return itemStack;
            }
            ItemStack itemStack = this.items[n].a(n2);
            if (this.items[n].count == 0) {
                this.items[n] = null;
            }
            return itemStack;
        }
        return null;
    }

    public ItemStack splitWithoutUpdate(int n) {
        if (this.items[n] != null) {
            ItemStack itemStack = this.items[n];
            this.items[n] = null;
            return itemStack;
        }
        return null;
    }

    public void setItem(int n, ItemStack itemStack) {
        this.items[n] = itemStack;
        if (itemStack != null && itemStack.count > this.getMaxStackSize()) {
            itemStack.count = this.getMaxStackSize();
        }
    }

    public String getName() {
        return "container.furnace";
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        NBTTagList nBTTagList = nBTTagCompound.getList("Items");
        this.items = new ItemStack[this.getSize()];
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound2 = (NBTTagCompound)nBTTagList.get(i);
            byte by = nBTTagCompound2.getByte("Slot");
            if (by < 0 || by >= this.items.length) continue;
            this.items[by] = ItemStack.a(nBTTagCompound2);
        }
        this.burnTime = nBTTagCompound.getShort("BurnTime");
        this.cookTime = nBTTagCompound.getShort("CookTime");
        this.ticksForCurrentFuel = TileEntityFurnace.fuelTime(this.items[1]);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setShort("BurnTime", (short)this.burnTime);
        nBTTagCompound.setShort("CookTime", (short)this.cookTime);
        NBTTagList nBTTagList = new NBTTagList();
        for (int i = 0; i < this.items.length; ++i) {
            if (this.items[i] == null) continue;
            NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
            nBTTagCompound2.setByte("Slot", (byte)i);
            this.items[i].save(nBTTagCompound2);
            nBTTagList.add(nBTTagCompound2);
        }
        nBTTagCompound.set("Items", nBTTagList);
    }

    public int getMaxStackSize() {
        return 64;
    }

    public boolean isBurning() {
        return this.burnTime > 0;
    }

    public void g() {
        boolean bl = this.burnTime > 0;
        boolean bl2 = false;
        if (this.burnTime > 0) {
            --this.burnTime;
        }
        if (!this.world.isStatic) {
            if (this.burnTime == 0 && this.canBurn()) {
                this.ticksForCurrentFuel = this.burnTime = TileEntityFurnace.fuelTime(this.items[1]);
                if (this.burnTime > 0) {
                    bl2 = true;
                    if (this.items[1] != null) {
                        --this.items[1].count;
                        if (this.items[1].count == 0) {
                            Item item = this.items[1].getItem().q();
                            ItemStack itemStack = this.items[1] = item != null ? new ItemStack(item) : null;
                        }
                    }
                }
            }
            if (this.isBurning() && this.canBurn()) {
                ++this.cookTime;
                if (this.cookTime == 200) {
                    this.cookTime = 0;
                    this.burn();
                    bl2 = true;
                }
            } else {
                this.cookTime = 0;
            }
            if (bl != this.burnTime > 0) {
                bl2 = true;
                BlockFurnace.a(this.burnTime > 0, this.world, this.x, this.y, this.z);
            }
        }
        if (bl2) {
            this.update();
        }
    }

    private boolean canBurn() {
        if (this.items[0] == null) {
            return false;
        }
        ItemStack itemStack = RecipesFurnace.getInstance().getResult(this.items[0].getItem().id);
        if (itemStack == null) {
            return false;
        }
        if (this.items[2] == null) {
            return true;
        }
        if (!this.items[2].doMaterialsMatch(itemStack)) {
            return false;
        }
        if (this.items[2].count < this.getMaxStackSize() && this.items[2].count < this.items[2].getMaxStackSize()) {
            return true;
        }
        return this.items[2].count < itemStack.getMaxStackSize();
    }

    public void burn() {
        if (!this.canBurn()) {
            return;
        }
        ItemStack itemStack = RecipesFurnace.getInstance().getResult(this.items[0].getItem().id);
        if (this.items[2] == null) {
            this.items[2] = itemStack.cloneItemStack();
        } else if (this.items[2].id == itemStack.id) {
            ++this.items[2].count;
        }
        --this.items[0].count;
        if (this.items[0].count <= 0) {
            this.items[0] = null;
        }
    }

    public static int fuelTime(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        int n = itemStack.getItem().id;
        Item item = itemStack.getItem();
        if (n < 256 && Block.byId[n] != null) {
            Block block = Block.byId[n];
            if (block == Block.WOOD_STEP) {
                return 150;
            }
            if (block.material == Material.WOOD) {
                return 300;
            }
        }
        if (item instanceof ItemTool && ((ItemTool)item).e().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemSword && ((ItemSword)item).f().equals("WOOD")) {
            return 200;
        }
        if (item instanceof ItemHoe && ((ItemHoe)item).f().equals("WOOD")) {
            return 200;
        }
        if (n == Item.STICK.id) {
            return 100;
        }
        if (n == Item.COAL.id) {
            return 1600;
        }
        if (n == Item.LAVA_BUCKET.id) {
            return 20000;
        }
        if (n == Block.SAPLING.id) {
            return 100;
        }
        if (n == Item.BLAZE_ROD.id) {
            return 2400;
        }
        return 0;
    }

    public static boolean isFuel(ItemStack itemStack) {
        return TileEntityFurnace.fuelTime(itemStack) > 0;
    }

    public boolean a(EntityHuman entityHuman) {
        if (this.world.getTileEntity(this.x, this.y, this.z) != this) {
            return false;
        }
        return !(entityHuman.e((double)this.x + 0.5, (double)this.y + 0.5, (double)this.z + 0.5) > 64.0);
    }

    public void startOpen() {
    }

    public void f() {
    }
}

