/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.ProtocolConstants;

public class ClientSettings
extends DefinedPacket {
    private String locale;
    private byte viewDistance;
    private byte chatFlags;
    private boolean unknown;
    private byte difficulty;
    private byte showCape;

    @Override
    public void read(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        this.locale = ClientSettings.readString(buf);
        this.viewDistance = buf.readByte();
        this.chatFlags = buf.readByte();
        this.unknown = buf.readBoolean();
        if (protocolVersion <= ProtocolConstants.MINECRAFT_1_7_6) {
            this.difficulty = buf.readByte();
        }
        this.showCape = buf.readByte();
    }

    @Override
    public void write(ByteBuf buf, ProtocolConstants.Direction direction, int protocolVersion) {
        ClientSettings.writeString(this.locale, buf);
        buf.writeByte(this.viewDistance);
        buf.writeByte(this.chatFlags);
        buf.writeBoolean(this.unknown);
        if (protocolVersion <= ProtocolConstants.MINECRAFT_1_7_6) {
            buf.writeByte(this.difficulty);
        }
        buf.writeByte(this.showCape);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getLocale() {
        return this.locale;
    }

    public byte getViewDistance() {
        return this.viewDistance;
    }

    public byte getChatFlags() {
        return this.chatFlags;
    }

    public boolean isUnknown() {
        return this.unknown;
    }

    public byte getDifficulty() {
        return this.difficulty;
    }

    public byte getShowCape() {
        return this.showCape;
    }

    public void setLocale(String locale) {
        this.locale = locale;
    }

    public void setViewDistance(byte viewDistance) {
        this.viewDistance = viewDistance;
    }

    public void setChatFlags(byte chatFlags) {
        this.chatFlags = chatFlags;
    }

    public void setUnknown(boolean unknown) {
        this.unknown = unknown;
    }

    public void setDifficulty(byte difficulty) {
        this.difficulty = difficulty;
    }

    public void setShowCape(byte showCape) {
        this.showCape = showCape;
    }

    @Override
    public String toString() {
        return "ClientSettings(locale=" + this.getLocale() + ", viewDistance=" + this.getViewDistance() + ", chatFlags=" + this.getChatFlags() + ", unknown=" + this.isUnknown() + ", difficulty=" + this.getDifficulty() + ", showCape=" + this.getShowCape() + ")";
    }

    public ClientSettings() {
    }

    @ConstructorProperties(value={"locale", "viewDistance", "chatFlags", "unknown", "difficulty", "showCape"})
    public ClientSettings(String locale, byte viewDistance, byte chatFlags, boolean unknown, byte difficulty, byte showCape) {
        this.locale = locale;
        this.viewDistance = viewDistance;
        this.chatFlags = chatFlags;
        this.unknown = unknown;
        this.difficulty = difficulty;
        this.showCape = showCape;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientSettings)) {
            return false;
        }
        ClientSettings other = (ClientSettings)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$locale = this.getLocale();
        String other$locale = other.getLocale();
        if (this$locale == null ? other$locale != null : !this$locale.equals(other$locale)) {
            return false;
        }
        if (this.getViewDistance() != other.getViewDistance()) {
            return false;
        }
        if (this.getChatFlags() != other.getChatFlags()) {
            return false;
        }
        if (this.isUnknown() != other.isUnknown()) {
            return false;
        }
        if (this.getDifficulty() != other.getDifficulty()) {
            return false;
        }
        return this.getShowCape() == other.getShowCape();
    }

    public boolean canEqual(Object other) {
        return other instanceof ClientSettings;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $locale = this.getLocale();
        result = result * 59 + ($locale == null ? 0 : $locale.hashCode());
        result = result * 59 + this.getViewDistance();
        result = result * 59 + this.getChatFlags();
        result = result * 59 + (this.isUnknown() ? 79 : 97);
        result = result * 59 + this.getDifficulty();
        result = result * 59 + this.getShowCape();
        return result;
    }
}

