/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.module;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.module.JenkinsModuleSource;
import net.md_5.bungee.module.ModuleSource;
import net.md_5.bungee.module.ModuleSpec;
import net.md_5.bungee.module.ModuleVersion;
import net.md_5.bungee.util.CaseInsensitiveMap;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class ModuleManager {
    private final Map<String, ModuleSource> knownSources = new HashMap<String, ModuleSource>();

    public ModuleManager() {
        this.knownSources.put("jenkins", new JenkinsModuleSource());
    }

    public void load(ProxyServer proxy, File moduleDirectory) throws Exception {
        CaseInsensitiveMap<Serializable> config;
        ModuleVersion bungeeVersion = ModuleVersion.parse(proxy.getVersion());
        if (bungeeVersion == null) {
            System.out.println("Could detect bungee version. Custom build?");
            return;
        }
        moduleDirectory.mkdir();
        ArrayList<ModuleSpec> modules = new ArrayList<ModuleSpec>();
        File configFile = new File("modules.yml");
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        configFile.createNewFile();
        try (FileInputStream is = new FileInputStream(configFile);){
            config = (CaseInsensitiveMap<Serializable>)yaml.load(is);
        }
        config = config == null ? new CaseInsensitiveMap<Serializable>() : new CaseInsensitiveMap(config);
        ArrayList<String> defaults = new ArrayList<String>();
        if (config.containsKey("modules")) {
            defaults.addAll((Collection)config.get("modules"));
        }
        int version = config.containsKey("version") ? (Integer)config.get("version") : 0;
        switch (version) {
            case 0: {
                defaults.add("jenkins://cmd_alert");
                defaults.add("jenkins://cmd_find");
                defaults.add("jenkins://cmd_list");
                defaults.add("jenkins://cmd_send");
                defaults.add("jenkins://cmd_server");
            }
            case 1: {
                defaults.add("jenkins://reconnect_yaml");
            }
        }
        config.put("modules", defaults);
        config.put("version", Integer.valueOf(2));
        try (FileWriter wr = new FileWriter(configFile);){
            yaml.dump(config, wr);
        }
        for (String s : (List)config.get("modules")) {
            URI uri = new URI(s);
            ModuleSource source = this.knownSources.get(uri.getScheme());
            if (source == null) {
                System.out.println("Unknown module source: " + s);
                continue;
            }
            String name = uri.getAuthority();
            if (name == null) {
                System.out.println("Unknown module host: " + s);
                continue;
            }
            ModuleSpec spec = new ModuleSpec(name, new File(moduleDirectory, name + ".jar"), source);
            modules.add(spec);
            System.out.println("Discovered module: " + spec);
        }
        for (ModuleSpec module : modules) {
            ModuleVersion moduleVersion = module.getFile().exists() ? this.getVersion(module.getFile()) : null;
            if (bungeeVersion.equals(moduleVersion)) continue;
            System.out.println("Attempting to update plugin from " + moduleVersion + " to " + bungeeVersion);
            module.getProvider().retrieve(module, bungeeVersion);
        }
    }

    /*
     * Exception decompiling
     */
    private ModuleVersion getVersion(File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

