/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCipher;
import net.md_5.bungee.NativeCipherImpl;

public class NativeCipher
implements BungeeCipher {
    private static final NativeCipherImpl nativeCipher = new NativeCipherImpl();
    private static boolean loaded;
    private boolean forEncryption;
    private long keyPointer;
    private long ivPointer;

    public static boolean isSupported() {
        return "Linux".equals(System.getProperty("os.name")) && "amd64".equals(System.getProperty("os.arch"));
    }

    public static boolean load() {
        if (!loaded && NativeCipher.isSupported()) {
            try (InputStream lib = BungeeCipher.class.getClassLoader().getResourceAsStream("native-cipher.so");){
                File temp = File.createTempFile("bungeecord-native-cipher", ".so");
                try (FileOutputStream outputStream = new FileOutputStream(temp);){
                    ByteStreams.copy(lib, (OutputStream)outputStream);
                    System.load(temp.getPath());
                }
                loaded = true;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return loaded;
    }

    public static boolean isLoaded() {
        return loaded;
    }

    @Override
    public void init(boolean forEncryption, SecretKey key) throws GeneralSecurityException {
        nativeCipher.free(this.keyPointer, this.ivPointer);
        this.forEncryption = forEncryption;
        byte[] encoded = key.getEncoded();
        this.keyPointer = nativeCipher.initKey(encoded);
        this.ivPointer = nativeCipher.initIV(encoded);
    }

    @Override
    public void free() {
        nativeCipher.free(this.keyPointer, this.ivPointer);
    }

    @Override
    public void cipher(ByteBuf in, ByteBuf out) throws GeneralSecurityException {
        in.memoryAddress();
        out.memoryAddress();
        Preconditions.checkState(this.keyPointer != 0L, "Invalid pointer to AES key!");
        Preconditions.checkState(this.ivPointer != 0L, "Invalid pointer to IV!");
        int length = in.readableBytes();
        out.ensureWritable(length);
        nativeCipher.cipher(this.forEncryption, this.keyPointer, this.ivPointer, in.memoryAddress() + (long)in.readerIndex(), out.memoryAddress() + (long)out.writerIndex(), length);
        in.readerIndex(in.writerIndex());
        out.writerIndex(out.writerIndex() + length);
    }

    @Override
    public ByteBuf cipher(ChannelHandlerContext ctx, ByteBuf in) throws GeneralSecurityException {
        int readableBytes = in.readableBytes();
        ByteBuf heapOut = ctx.alloc().directBuffer(readableBytes);
        this.cipher(in, heapOut);
        return heapOut;
    }

    public static NativeCipherImpl getNativeCipher() {
        return nativeCipher;
    }
}

