/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.ClickEvent;
import net.md_5.bungee.Color;
import net.md_5.bungee.Message;

public class ChatConverter {
    private static final Gson gson = new Gson();
    private static final char COLOR_CHAR = '\u00a7';
    private static final Pattern url = Pattern.compile("^(?:(https?)://)?([-\\w_\\.]{2,}\\.[a-z]{2,4})(/\\S*)?$");

    public static String[] toJSONChat(String txt) {
        Message msg = new Message();
        ArrayList<String> parts = new ArrayList<String>();
        StringBuilder outBuffer = new StringBuilder("[");
        StringBuilder buf = new StringBuilder();
        Matcher matcher = url.matcher(txt);
        block7: for (int i = 0; i < txt.length(); ++i) {
            char c = txt.charAt(i);
            if (c != '\u00a7') {
                int pos = txt.indexOf(32, i);
                if (pos == -1) {
                    pos = txt.length();
                }
                if (matcher.region(i, pos).find()) {
                    msg.text = buf.toString();
                    buf = new StringBuilder();
                    outBuffer = ChatConverter.append(parts, outBuffer, msg);
                    Message old = msg;
                    msg = new Message(old);
                    msg.clickEvent = new ClickEvent();
                    msg.clickEvent.action = "open_url";
                    String urlString = txt.substring(i, pos);
                    if (urlString.startsWith("http")) {
                        msg.text = msg.clickEvent.value = urlString;
                    } else {
                        msg.text = urlString;
                        msg.clickEvent.value = "http://" + urlString;
                    }
                    outBuffer = ChatConverter.append(parts, outBuffer, msg);
                    i += pos - i - 1;
                    msg = new Message(old);
                    continue;
                }
                buf.append(c);
                continue;
            }
            if ((c = txt.charAt(++i)) >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            msg.text = buf.toString();
            buf = new StringBuilder();
            outBuffer = ChatConverter.append(parts, outBuffer, msg);
            msg = new Message(msg);
            switch (c) {
                case 'k': {
                    msg.obfuscated = Boolean.TRUE;
                    continue block7;
                }
                case 'l': {
                    msg.bold = Boolean.TRUE;
                    continue block7;
                }
                case 'm': {
                    msg.strikethrough = Boolean.TRUE;
                    continue block7;
                }
                case 'n': {
                    msg.underlined = Boolean.TRUE;
                    continue block7;
                }
                case 'o': {
                    msg.italic = Boolean.TRUE;
                    continue block7;
                }
                default: {
                    msg.obfuscated = null;
                    msg.bold = null;
                    msg.strikethrough = null;
                    msg.underlined = null;
                    msg.italic = null;
                    msg.color = c != 'r' ? Color.fromCode(Character.toString(c)) : Color.WHITE;
                }
            }
        }
        msg.text = buf.toString();
        ChatConverter.append(parts, outBuffer, msg);
        parts.add(outBuffer.append("]").toString());
        String[] pArray = new String[parts.size()];
        parts.toArray(pArray);
        return pArray;
    }

    private static StringBuilder append(ArrayList<String> parts, StringBuilder outBuffer, Message part) {
        String p = gson.toJson(part);
        if (p.length() + outBuffer.length() + 1 >= 32747) {
            outBuffer.append("]");
            parts.add(outBuffer.toString());
            outBuffer = new StringBuilder("[");
        }
        if (outBuffer.length() != 1) {
            outBuffer.append(",");
        }
        outBuffer.append(p);
        return outBuffer;
    }
}

