/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.beans.ConstructorProperties;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Arrays;
import net.md_5.bungee.protocol.AbstractPacketHandler;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.MinecraftInput;

public class PluginMessage
extends DefinedPacket {
    private String tag;
    private byte[] data;

    @Override
    public void read(ByteBuf buf) {
        this.tag = PluginMessage.readString(buf);
        this.data = PluginMessage.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        PluginMessage.writeString(this.tag, buf);
        PluginMessage.writeArray(this.data, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public DataInput getStream() {
        return new DataInputStream(new ByteArrayInputStream(this.data));
    }

    public MinecraftInput getMCStream() {
        return new MinecraftInput(Unpooled.wrappedBuffer(this.data));
    }

    public String getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setData(byte[] data) {
        this.data = data;
    }

    @Override
    public String toString() {
        return "PluginMessage(tag=" + this.getTag() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    public PluginMessage() {
    }

    @ConstructorProperties(value={"tag", "data"})
    public PluginMessage(String tag, byte[] data) {
        this.tag = tag;
        this.data = data;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PluginMessage)) {
            return false;
        }
        PluginMessage other = (PluginMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    public boolean canEqual(Object other) {
        return other instanceof PluginMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $tag = this.getTag();
        result = result * 31 + ($tag == null ? 0 : $tag.hashCode());
        result = result * 31 + Arrays.hashCode(this.getData());
        return result;
    }
}

