/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.http;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import java.net.URI;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.http.HttpInitializer;

public class HttpClient {
    public static int TIMEOUT = 5000;

    public static void get(String url, EventLoop eventLoop, final Callback<String> callback) {
        Preconditions.checkNotNull(url, "url");
        Preconditions.checkNotNull(eventLoop, "eventLoop");
        Preconditions.checkNotNull(callback, "callBack");
        final URI uri = URI.create(url);
        Preconditions.checkNotNull(uri.getScheme(), "scheme");
        Preconditions.checkNotNull(uri.getHost(), "host");
        boolean ssl = uri.getScheme().equals("https");
        int port = uri.getPort();
        if (port == -1) {
            switch (uri.getScheme()) {
                case "http": {
                    port = 80;
                    break;
                }
                case "https": {
                    port = 443;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown scheme " + uri.getScheme());
                }
            }
        }
        ChannelFutureListener future = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    String path = uri.getRawPath() + (uri.getRawQuery() == null ? "" : "?" + uri.getRawQuery());
                    DefaultHttpRequest request = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, path);
                    request.headers().set("Host", uri.getHost());
                    future.channel().writeAndFlush(request);
                } else {
                    callback.done(null, future.cause());
                }
            }
        };
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(eventLoop)).handler(new HttpInitializer(callback, ssl))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, TIMEOUT)).remoteAddress(uri.getHost(), port).connect().addListener(future);
    }

    private HttpClient() {
    }
}

