/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.beans.ConstructorProperties;
import java.util.List;
import net.md_5.bungee.protocol.BadPacketException;
import net.md_5.bungee.protocol.DefinedPacket;
import net.md_5.bungee.protocol.PacketWrapper;
import net.md_5.bungee.protocol.Protocol;

public class MinecraftDecoder
extends ByteToMessageDecoder {
    private Protocol protocol;
    private boolean server;

    @Override
    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) throws Exception {
        Protocol.ProtocolDirection prot = this.server ? this.protocol.TO_SERVER : this.protocol.TO_CLIENT;
        ByteBuf copy = in.copy();
        int packetId = DefinedPacket.readVarInt(in);
        DefinedPacket packet = null;
        if (prot.hasPacket(packetId)) {
            packet = prot.createPacket(packetId);
            packet.read(in);
            if (in.readableBytes() != 0) {
                throw new BadPacketException("Did not read all bytes from packet " + packet.getClass() + " " + packetId + " Protocol " + (Object)((Object)this.protocol) + " Direction " + prot);
            }
        } else {
            in.skipBytes(in.readableBytes());
        }
        out.add(new PacketWrapper(packet, copy));
    }

    @ConstructorProperties(value={"protocol", "server"})
    public MinecraftDecoder(Protocol protocol, boolean server) {
        this.protocol = protocol;
        this.server = server;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }
}

