/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.api.plugin;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.eventbus.Subscribe;
import java.beans.ConstructorProperties;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Event;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginClassloader;
import net.md_5.bungee.api.plugin.PluginDescription;
import net.md_5.bungee.api.plugin.TabExecutor;
import net.md_5.bungee.event.EventBus;
import org.yaml.snakeyaml.Yaml;

public class PluginManager {
    private static final Pattern argsSplit = Pattern.compile(" ");
    private final ProxyServer proxy;
    private final Yaml yaml = new Yaml();
    private final EventBus eventBus;
    private final Map<String, Plugin> plugins = new LinkedHashMap<String, Plugin>();
    private final Map<String, Command> commandMap = new HashMap<String, Command>();
    private Map<String, PluginDescription> toLoad = new HashMap<String, PluginDescription>();
    private Multimap<Plugin, Command> commandsByPlugin = ArrayListMultimap.create();
    private Multimap<Plugin, Listener> listenersByPlugin = ArrayListMultimap.create();

    public PluginManager(ProxyServer proxy) {
        this.proxy = proxy;
        this.eventBus = new EventBus(proxy.getLogger());
    }

    public void registerCommand(Plugin plugin, Command command) {
        this.commandMap.put(command.getName().toLowerCase(), command);
        for (String alias : command.getAliases()) {
            this.commandMap.put(alias.toLowerCase(), command);
        }
        this.commandsByPlugin.put(plugin, command);
    }

    public void unregisterCommand(Command command) {
        this.commandMap.values().remove(command);
        this.commandsByPlugin.values().remove(command);
    }

    public void unregisterCommands(Plugin plugin) {
        Iterator<Command> it = this.commandsByPlugin.get(plugin).iterator();
        while (it.hasNext()) {
            this.commandMap.values().remove(it.next());
            it.remove();
        }
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine) {
        return this.dispatchCommand(sender, commandLine, null);
    }

    public boolean dispatchCommand(CommandSender sender, String commandLine, List<String> tabResults) {
        String[] args;
        String[] split = argsSplit.split(commandLine);
        if (split.length == 0) {
            return false;
        }
        String commandName = split[0].toLowerCase();
        if (this.proxy.getDisabledCommands().contains(commandName)) {
            return false;
        }
        Command command = this.commandMap.get(commandName);
        if (command == null) {
            return false;
        }
        String permission = command.getPermission();
        if (permission != null && !permission.isEmpty() && !sender.hasPermission(permission)) {
            sender.sendMessage(this.proxy.getTranslation("no_permission"));
            return true;
        }
        if (commandLine.endsWith(" ")) {
            args = Arrays.copyOfRange(split, 1, split.length + 1);
            args[split.length - 1] = "";
        } else {
            args = Arrays.copyOfRange(split, 1, split.length);
        }
        try {
            if (tabResults == null) {
                command.execute(sender, args);
            } else if (command instanceof TabExecutor) {
                for (String s : ((TabExecutor)((Object)command)).onTabComplete(sender, args)) {
                    tabResults.add(s);
                }
            }
        }
        catch (Exception ex) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "An internal error occurred whilst executing this command, please check the console log for details.");
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Error in dispatching command", ex);
        }
        return true;
    }

    public Collection<Plugin> getPlugins() {
        return this.plugins.values();
    }

    public Plugin getPlugin(String name) {
        return this.plugins.get(name);
    }

    public void loadAndEnablePlugins() {
        HashMap<PluginDescription, Boolean> pluginStatuses = new HashMap<PluginDescription, Boolean>();
        for (Map.Entry<String, PluginDescription> entry : this.toLoad.entrySet()) {
            PluginDescription plugin = entry.getValue();
            if (this.enablePlugin(pluginStatuses, new Stack<PluginDescription>(), plugin)) continue;
            ProxyServer.getInstance().getLogger().warning("Failed to enable " + entry.getKey());
        }
        this.toLoad.clear();
        this.toLoad = null;
        for (Plugin plugin : this.plugins.values()) {
            try {
                plugin.onEnable();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Enabled plugin {0} version {1} by {2}", new Object[]{plugin.getDescription().getName(), plugin.getDescription().getVersion(), plugin.getDescription().getAuthor()});
            }
            catch (Throwable t) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Exception encountered when loading plugin: " + plugin.getDescription().getName(), t);
            }
        }
    }

    private boolean enablePlugin(Map<PluginDescription, Boolean> pluginStatuses, Stack<PluginDescription> dependStack, PluginDescription plugin) {
        if (pluginStatuses.containsKey(plugin)) {
            return pluginStatuses.get(plugin);
        }
        boolean status = true;
        for (String dependName : plugin.getDepends()) {
            Boolean dependStatus;
            PluginDescription depend = this.toLoad.get(dependName);
            Boolean bl = dependStatus = depend != null ? pluginStatuses.get(depend) : Boolean.FALSE;
            if (dependStatus == null) {
                if (dependStack.contains(depend)) {
                    StringBuilder dependencyGraph = new StringBuilder();
                    for (PluginDescription element : dependStack) {
                        dependencyGraph.append(element.getName()).append(" -> ");
                    }
                    dependencyGraph.append(plugin.getName()).append(" -> ").append(dependName);
                    ProxyServer.getInstance().getLogger().log(Level.WARNING, "Circular dependency detected: " + dependencyGraph);
                    status = false;
                } else {
                    dependStack.push(plugin);
                    dependStatus = this.enablePlugin(pluginStatuses, dependStack, depend);
                    dependStack.pop();
                }
            }
            if (dependStatus == Boolean.FALSE) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "{0} (required by {1}) is unavailable", new Object[]{String.valueOf(depend.getName()), plugin.getName()});
                status = false;
            }
            if (status) continue;
            break;
        }
        if (status) {
            try {
                PluginClassloader loader = new PluginClassloader(new URL[]{plugin.getFile().toURI().toURL()});
                Class<?> main = loader.loadClass(plugin.getMain());
                Plugin clazz = (Plugin)main.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                clazz.init(this.proxy, plugin);
                this.plugins.put(plugin.getName(), clazz);
                clazz.onLoad();
                ProxyServer.getInstance().getLogger().log(Level.INFO, "Loaded plugin {0} version {1} by {2}", new Object[]{plugin.getName(), plugin.getVersion(), plugin.getAuthor()});
            }
            catch (Throwable t) {
                this.proxy.getLogger().log(Level.WARNING, "Error enabling plugin " + plugin.getName(), t);
            }
        }
        pluginStatuses.put(plugin, status);
        return status;
    }

    public void detectPlugins(File folder) {
        Preconditions.checkNotNull(folder, "folder");
        Preconditions.checkArgument(folder.isDirectory(), "Must load from a directory");
        for (File file : folder.listFiles()) {
            if (!file.isFile() || !file.getName().endsWith(".jar")) continue;
            try (JarFile jar = new JarFile(file);){
                JarEntry pdf = jar.getJarEntry("plugin.yml");
                Preconditions.checkNotNull(pdf, "Plugin must have a plugin.yml");
                try (InputStream in = jar.getInputStream(pdf);){
                    PluginDescription desc = this.yaml.loadAs(in, PluginDescription.class);
                    desc.setFile(file);
                    this.toLoad.put(desc.getName(), desc);
                }
            }
            catch (Exception ex) {
                ProxyServer.getInstance().getLogger().log(Level.WARNING, "Could not load plugin from file " + file, ex);
            }
        }
    }

    public <T extends Event> T callEvent(T event) {
        Preconditions.checkNotNull(event, "event");
        long start = System.nanoTime();
        this.eventBus.post(event);
        event.postCall();
        long elapsed = start - System.nanoTime();
        if (elapsed > 250000L) {
            ProxyServer.getInstance().getLogger().log(Level.WARNING, "Event {0} took more {1}ns to process!", new Object[]{event, elapsed});
        }
        return event;
    }

    public void registerListener(Plugin plugin, Listener listener) {
        for (Method method : listener.getClass().getDeclaredMethods()) {
            Preconditions.checkArgument(!method.isAnnotationPresent(Subscribe.class), "Listener %s has registered using deprecated subscribe annotation! Please update to @EventHandler.", listener);
        }
        this.eventBus.register(listener);
        this.listenersByPlugin.put(plugin, listener);
    }

    public void unregisterListener(Listener listener) {
        this.eventBus.unregister(listener);
        this.listenersByPlugin.values().remove(listener);
    }

    public void unregisterListeners(Plugin plugin) {
        Iterator<Listener> it = this.listenersByPlugin.get(plugin).iterator();
        while (it.hasNext()) {
            this.eventBus.unregister(it.next());
            it.remove();
        }
    }

    @ConstructorProperties(value={"proxy", "eventBus"})
    public PluginManager(ProxyServer proxy, EventBus eventBus) {
        this.proxy = proxy;
        this.eventBus = eventBus;
    }
}

