/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import com.google.common.base.Preconditions;
import io.netty.util.concurrent.ScheduledFuture;
import java.beans.ConstructorProperties;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EncryptionUtil;
import net.md_5.bungee.PacketConstants;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.AbstractReconnectHandler;
import net.md_5.bungee.api.Callback;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.ServerPing;
import net.md_5.bungee.api.config.ListenerInfo;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.connection.Connection;
import net.md_5.bungee.api.connection.PendingConnection;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.LoginEvent;
import net.md_5.bungee.api.event.PostLoginEvent;
import net.md_5.bungee.api.event.ProxyPingEvent;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.connection.UpstreamBridge;
import net.md_5.bungee.http.HttpClient;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.CipherDecoder;
import net.md_5.bungee.netty.CipherEncoder;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PacketDecoder;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.protocol.Forge;
import net.md_5.bungee.protocol.MinecraftInput;
import net.md_5.bungee.protocol.packet.DefinedPacket;
import net.md_5.bungee.protocol.packet.Packet1Login;
import net.md_5.bungee.protocol.packet.Packet2Handshake;
import net.md_5.bungee.protocol.packet.PacketCDClientStatus;
import net.md_5.bungee.protocol.packet.PacketFAPluginMessage;
import net.md_5.bungee.protocol.packet.PacketFCEncryptionResponse;
import net.md_5.bungee.protocol.packet.PacketFDEncryptionRequest;
import net.md_5.bungee.protocol.packet.PacketFEPing;
import net.md_5.bungee.protocol.packet.PacketFFKick;

public class InitialHandler
extends PacketHandler
implements PendingConnection {
    private final ProxyServer bungee;
    private ChannelWrapper ch;
    private final ListenerInfo listener;
    private Packet1Login forgeLogin;
    private Packet2Handshake handshake;
    private PacketFDEncryptionRequest request;
    private List<PacketFAPluginMessage> loginMessages = new ArrayList<PacketFAPluginMessage>();
    private List<PacketFAPluginMessage> registerMessages = new ArrayList<PacketFAPluginMessage>();
    private State thisState = State.HANDSHAKE;
    private SecretKey sharedKey;
    private final Connection.Unsafe unsafe = new Connection.Unsafe(){

        @Override
        public void sendPacket(DefinedPacket packet) {
            InitialHandler.this.ch.write(packet);
        }
    };
    private ScheduledFuture<?> pingFuture;
    private InetSocketAddress vHost;
    private byte version = (byte)-1;

    @Override
    public void connected(ChannelWrapper channel) throws Exception {
        this.ch = channel;
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.disconnect((Object)((Object)ChatColor.RED) + Util.exception(t));
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("MC|PingHost")) {
            if (this.pingFuture.cancel(false)) {
                MinecraftInput in = pluginMessage.getMCStream();
                this.version = in.readByte();
                String connectHost = in.readString();
                int connectPort = in.readInt();
                this.vHost = new InetSocketAddress(connectHost, connectPort);
                this.respondToPing();
            }
            return;
        }
        if (pluginMessage.getTag().equals("REGISTER")) {
            this.registerMessages.add(pluginMessage);
        } else {
            this.loginMessages.add(pluginMessage);
        }
    }

    private void respondToPing() {
        ServerInfo forced = AbstractReconnectHandler.getForcedHost(this);
        String motd = forced != null ? forced.getMotd() : this.listener.getMotd();
        Callback<ServerPing> pingBack = new Callback<ServerPing>(){

            @Override
            public void done(ServerPing result, Throwable error) {
                if (error != null) {
                    result = new ServerPing(-1, "-1", "Error pinging remote server: " + Util.exception(error), -1, -1);
                }
                result = InitialHandler.this.bungee.getPluginManager().callEvent(new ProxyPingEvent(InitialHandler.this, result)).getResponse();
                String kickMessage = (Object)((Object)ChatColor.DARK_BLUE) + "\u0000" + result.getProtocolVersion() + "\u0000" + result.getGameVersion() + "\u0000" + result.getMotd() + "\u0000" + result.getCurrentPlayers() + "\u0000" + result.getMaxPlayers();
                BungeeCord.getInstance().getConnectionThrottle().unthrottle(InitialHandler.this.getAddress().getAddress());
                InitialHandler.this.disconnect(kickMessage);
            }
        };
        if (forced != null && this.listener.isPingPassthrough()) {
            forced.ping(pingBack);
        } else {
            pingBack.done(new ServerPing(this.bungee.getProtocolVersion(), this.bungee.getGameVersion(), motd, this.bungee.getOnlineCount(), this.listener.getMaxPlayers()), null);
        }
    }

    @Override
    public void handle(PacketFEPing ping) throws Exception {
        this.pingFuture = this.ch.getHandle().eventLoop().schedule(new Runnable(){

            @Override
            public void run() {
                InitialHandler.this.respondToPing();
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    @Override
    public void handle(Packet1Login login) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not expecting FORGE LOGIN");
        Preconditions.checkState(this.forgeLogin == null, "Already received FORGE LOGIN");
        this.forgeLogin = login;
        this.ch.getHandle().pipeline().get(PacketDecoder.class).setProtocol(Forge.getInstance());
    }

    @Override
    public void handle(Packet2Handshake handshake) throws Exception {
        Preconditions.checkState(this.thisState == State.HANDSHAKE, "Not expecting HANDSHAKE");
        this.handshake = handshake;
        this.vHost = new InetSocketAddress(handshake.getHost(), handshake.getPort());
        this.bungee.getLogger().log(Level.INFO, "{0} has connected", this);
        if (handshake.getProtocolVersion() > 78) {
            this.disconnect(this.bungee.getTranslation("outdated_server"));
        } else if (handshake.getProtocolVersion() < 78) {
            this.disconnect(this.bungee.getTranslation("outdated_client"));
        }
        if (handshake.getUsername().length() > 16) {
            this.disconnect("Cannot have username longer than 16 characters");
            return;
        }
        int limit = BungeeCord.getInstance().config.getPlayerLimit();
        if (limit > 0 && this.bungee.getOnlineCount() > limit) {
            this.disconnect(this.bungee.getTranslation("proxy_full"));
            return;
        }
        if (!BungeeCord.getInstance().config.isOnlineMode() && this.bungee.getPlayer(handshake.getUsername()) != null) {
            this.disconnect(this.bungee.getTranslation("already_connected"));
            return;
        }
        this.unsafe().sendPacket(PacketConstants.I_AM_BUNGEE);
        this.unsafe().sendPacket(PacketConstants.FORGE_MOD_REQUEST);
        this.request = EncryptionUtil.encryptRequest();
        this.unsafe().sendPacket(this.request);
        this.thisState = State.ENCRYPT;
    }

    @Override
    public void handle(PacketFCEncryptionResponse encryptResponse) throws Exception {
        Preconditions.checkState(this.thisState == State.ENCRYPT, "Not expecting ENCRYPT");
        this.sharedKey = EncryptionUtil.getSecret(encryptResponse, this.request);
        Cipher decrypt = EncryptionUtil.getCipher(2, this.sharedKey);
        this.ch.addBefore(PipelineUtils.PACKET_DECODE_HANDLER, PipelineUtils.DECRYPT_HANDLER, new CipherDecoder(decrypt));
        if (BungeeCord.getInstance().config.isOnlineMode()) {
            String encName = URLEncoder.encode(this.getName(), "UTF-8");
            MessageDigest sha = MessageDigest.getInstance("SHA-1");
            for (byte[] bit : new byte[][]{this.request.getServerId().getBytes("ISO_8859_1"), this.sharedKey.getEncoded(), EncryptionUtil.keys.getPublic().getEncoded()}) {
                sha.update(bit);
            }
            String encodedHash = URLEncoder.encode(new BigInteger(sha.digest()).toString(16), "UTF-8");
            String authURL = "http://session.minecraft.net/game/checkserver.jsp?user=" + encName + "&serverId=" + encodedHash;
            Callback<String> handler = new Callback<String>(){

                @Override
                public void done(String result, Throwable error) {
                    if (error == null) {
                        if ("YES".equals(result)) {
                            InitialHandler.this.finish();
                        } else {
                            InitialHandler.this.disconnect("Not authenticated with Minecraft.net");
                        }
                    } else {
                        InitialHandler.this.disconnect(InitialHandler.this.bungee.getTranslation("mojang_fail"));
                        InitialHandler.this.bungee.getLogger().log(Level.SEVERE, "Error authenticating " + InitialHandler.this.getName() + " with minecraft.net", error);
                    }
                }
            };
            HttpClient.get(authURL, this.ch.getHandle().eventLoop(), handler);
        } else {
            this.finish();
        }
    }

    private void finish() {
        ProxiedPlayer old = this.bungee.getPlayer(this.handshake.getUsername());
        if (old != null) {
            old.disconnect(this.bungee.getTranslation("already_connected"));
        }
        Callback<LoginEvent> complete = new Callback<LoginEvent>(){

            @Override
            public void done(LoginEvent result, Throwable error) {
                if (result.isCancelled()) {
                    InitialHandler.this.disconnect(result.getCancelReason());
                }
                if (InitialHandler.this.ch.isClosed()) {
                    return;
                }
                InitialHandler.this.thisState = State.LOGIN;
                InitialHandler.this.ch.getHandle().eventLoop().execute(new Runnable(){

                    @Override
                    public void run() {
                        if (InitialHandler.this.ch.getHandle().isActive()) {
                            InitialHandler.this.unsafe().sendPacket(new PacketFCEncryptionResponse(new byte[0], new byte[0]));
                            try {
                                Cipher encrypt = EncryptionUtil.getCipher(1, InitialHandler.this.sharedKey);
                                InitialHandler.this.ch.addBefore(PipelineUtils.DECRYPT_HANDLER, PipelineUtils.ENCRYPT_HANDLER, new CipherEncoder(encrypt));
                            }
                            catch (GeneralSecurityException ex) {
                                InitialHandler.this.disconnect("Cipher error: " + Util.exception(ex));
                            }
                        }
                    }
                });
            }
        };
        this.bungee.getPluginManager().callEvent(new LoginEvent(this, complete));
    }

    @Override
    public void handle(PacketCDClientStatus clientStatus) throws Exception {
        Preconditions.checkState(this.thisState == State.LOGIN, "Not expecting LOGIN");
        UserConnection userCon = new UserConnection(this.bungee, this.ch, this.getName(), this);
        userCon.init();
        this.bungee.getPluginManager().callEvent(new PostLoginEvent(userCon));
        this.ch.getHandle().pipeline().get(HandlerBoss.class).setHandler(new UpstreamBridge(this.bungee, userCon));
        ServerInfo server = this.bungee.getReconnectHandler() != null ? this.bungee.getReconnectHandler().getServer(userCon) : AbstractReconnectHandler.getForcedHost(this);
        userCon.connect(server, true);
        this.thisState = State.FINISHED;
        throw new CancelSendSignal();
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (!this.ch.isClosed()) {
            this.unsafe().sendPacket(new PacketFFKick(reason));
            this.ch.close();
        }
    }

    @Override
    public String getName() {
        return this.handshake == null ? null : this.handshake.getUsername();
    }

    @Override
    public byte getVersion() {
        return this.handshake == null ? this.version : this.handshake.getProtocolVersion();
    }

    @Override
    public InetSocketAddress getVirtualHost() {
        return this.vHost;
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    @Override
    public Connection.Unsafe unsafe() {
        return this.unsafe;
    }

    @Override
    public String toString() {
        return "[" + (this.getName() != null ? this.getName() : this.getAddress()) + "] <-> InitialHandler";
    }

    @ConstructorProperties(value={"bungee", "listener"})
    public InitialHandler(ProxyServer bungee, ListenerInfo listener) {
        this.bungee = bungee;
        this.listener = listener;
    }

    @Override
    public ListenerInfo getListener() {
        return this.listener;
    }

    public Packet1Login getForgeLogin() {
        return this.forgeLogin;
    }

    public Packet2Handshake getHandshake() {
        return this.handshake;
    }

    public List<PacketFAPluginMessage> getLoginMessages() {
        return this.loginMessages;
    }

    public List<PacketFAPluginMessage> getRegisterMessages() {
        return this.registerMessages;
    }

    private static enum State {
        HANDSHAKE,
        ENCRYPT,
        LOGIN,
        FINISHED;

    }
}

