/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class PacketCBTabComplete
extends DefinedPacket {
    private String cursor;
    private String[] commands;

    private PacketCBTabComplete() {
        super(203);
    }

    public PacketCBTabComplete(String[] alternatives) {
        this();
        this.commands = alternatives;
    }

    @Override
    public void read(ByteBuf buf) {
        this.cursor = this.readString(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        String tab = "";
        for (String alternative : this.commands) {
            tab = tab.isEmpty() ? alternative + " " : tab + "\u0000" + alternative + " ";
        }
        this.writeString(tab, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getCursor() {
        return this.cursor;
    }

    public String[] getCommands() {
        return this.commands;
    }

    @Override
    public String toString() {
        return "PacketCBTabComplete(cursor=" + this.getCursor() + ", commands=" + Arrays.deepToString(this.getCommands()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketCBTabComplete)) {
            return false;
        }
        PacketCBTabComplete other = (PacketCBTabComplete)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        if (this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor)) {
            return false;
        }
        return Arrays.deepEquals(this.getCommands(), other.getCommands());
    }

    public boolean canEqual(Object other) {
        return other instanceof PacketCBTabComplete;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $cursor = this.getCursor();
        result = result * 31 + ($cursor == null ? 0 : $cursor.hashCode());
        result = result * 31 + Arrays.deepHashCode(this.getCommands());
        return result;
    }
}

