/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.connection;

import java.util.ArrayList;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.EntityMap;
import net.md_5.bungee.UserConnection;
import net.md_5.bungee.Util;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.event.ChatEvent;
import net.md_5.bungee.api.event.PlayerDisconnectEvent;
import net.md_5.bungee.api.event.PluginMessageEvent;
import net.md_5.bungee.connection.CancelSendSignal;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.PacketHandler;
import net.md_5.bungee.netty.PacketWrapper;
import net.md_5.bungee.protocol.packet.Packet0KeepAlive;
import net.md_5.bungee.protocol.packet.Packet3Chat;
import net.md_5.bungee.protocol.packet.PacketCBTabComplete;
import net.md_5.bungee.protocol.packet.PacketCCSettings;
import net.md_5.bungee.protocol.packet.PacketFAPluginMessage;

public class UpstreamBridge
extends PacketHandler {
    private final ProxyServer bungee;
    private final UserConnection con;

    public UpstreamBridge(ProxyServer bungee, UserConnection con) {
        this.bungee = bungee;
        this.con = con;
        BungeeCord.getInstance().addConnection(con);
        con.getTabList().onConnect();
        con.unsafe().sendPacket(BungeeCord.getInstance().registerChannels());
    }

    @Override
    public void exception(Throwable t) throws Exception {
        this.con.disconnect(Util.exception(t));
    }

    @Override
    public void disconnected(ChannelWrapper channel) throws Exception {
        PlayerDisconnectEvent event = new PlayerDisconnectEvent(this.con);
        this.bungee.getPluginManager().callEvent(event);
        this.con.getTabList().onDisconnect();
        BungeeCord.getInstance().removeConnection(this.con);
        if (this.con.getServer() != null) {
            this.con.getServer().disconnect("Quitting");
        }
    }

    @Override
    public void handle(PacketWrapper packet) throws Exception {
        EntityMap.rewrite(packet.buf, this.con.getClientEntityId(), this.con.getServerEntityId());
        if (this.con.getServer() != null) {
            this.con.getServer().getCh().write(packet);
        }
    }

    @Override
    public void handle(Packet0KeepAlive alive) throws Exception {
        if (alive.getRandomId() == this.con.getSentPingId()) {
            int newPing = (int)(System.currentTimeMillis() - this.con.getSentPingTime());
            this.con.getTabList().onPingChange(newPing);
            this.con.setPing(newPing);
        }
    }

    @Override
    public void handle(Packet3Chat chat) throws Exception {
        ChatEvent chatEvent = new ChatEvent(this.con, this.con.getServer(), chat.getMessage());
        if (!this.bungee.getPluginManager().callEvent(chatEvent).isCancelled()) {
            chat.setMessage(chatEvent.getMessage());
            if (!chatEvent.isCommand() || !this.bungee.getPluginManager().dispatchCommand(this.con, chat.getMessage().substring(1))) {
                this.con.getServer().unsafe().sendPacket(chat);
            }
        }
        throw new CancelSendSignal();
    }

    @Override
    public void handle(PacketCBTabComplete tabComplete) throws Exception {
        if (tabComplete.getCursor().startsWith("/")) {
            ArrayList<String> results = new ArrayList<String>();
            this.bungee.getPluginManager().dispatchCommand(this.con, tabComplete.getCursor(), results);
            this.con.unsafe().sendPacket(new PacketCBTabComplete(results.toArray(new String[results.size()])));
            throw new CancelSendSignal();
        }
    }

    @Override
    public void handle(PacketCCSettings settings) throws Exception {
        this.con.setSettings(settings);
    }

    @Override
    public void handle(PacketFAPluginMessage pluginMessage) throws Exception {
        if (pluginMessage.getTag().equals("BungeeCord")) {
            throw new CancelSendSignal();
        }
        if (pluginMessage.getTag().equals("FML") && pluginMessage.getStream().readUnsignedByte() == 1) {
            throw new CancelSendSignal();
        }
        PluginMessageEvent event = new PluginMessageEvent(this.con, this.con.getServer(), pluginMessage.getTag(), (byte[])pluginMessage.getData().clone());
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            throw new CancelSendSignal();
        }
        if (pluginMessage.getTag().equals("REGISTER")) {
            this.con.getPendingConnection().getRegisterMessages().add(pluginMessage);
        }
    }

    @Override
    public String toString() {
        return "[" + this.con.getName() + "] -> UpstreamBridge";
    }
}

