/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class PacketFDEncryptionRequest
extends DefinedPacket {
    private String serverId;
    private byte[] publicKey;
    private byte[] verifyToken;

    private PacketFDEncryptionRequest() {
        super(253);
    }

    public PacketFDEncryptionRequest(String serverId, byte[] publicKey, byte[] verifyToken) {
        this();
        this.serverId = serverId;
        this.publicKey = publicKey;
        this.verifyToken = verifyToken;
    }

    @Override
    public void read(ByteBuf buf) {
        this.serverId = this.readString(buf);
        this.publicKey = this.readArray(buf);
        this.verifyToken = this.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        this.writeString(this.serverId, buf);
        this.writeArray(this.publicKey, buf);
        this.writeArray(this.verifyToken, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public String getServerId() {
        return this.serverId;
    }

    public byte[] getPublicKey() {
        return this.publicKey;
    }

    public byte[] getVerifyToken() {
        return this.verifyToken;
    }

    @Override
    public String toString() {
        return "PacketFDEncryptionRequest(serverId=" + this.getServerId() + ", publicKey=" + Arrays.toString(this.getPublicKey()) + ", verifyToken=" + Arrays.toString(this.getVerifyToken()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketFDEncryptionRequest)) {
            return false;
        }
        PacketFDEncryptionRequest other = (PacketFDEncryptionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serverId = this.getServerId();
        String other$serverId = other.getServerId();
        if (this$serverId == null ? other$serverId != null : !this$serverId.equals(other$serverId)) {
            return false;
        }
        if (!Arrays.equals(this.getPublicKey(), other.getPublicKey())) {
            return false;
        }
        return Arrays.equals(this.getVerifyToken(), other.getVerifyToken());
    }

    public boolean canEqual(Object other) {
        return other instanceof PacketFDEncryptionRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $serverId = this.getServerId();
        result = result * 31 + ($serverId == null ? 0 : $serverId.hashCode());
        result = result * 31 + Arrays.hashCode(this.getPublicKey());
        result = result * 31 + Arrays.hashCode(this.getVerifyToken());
        return result;
    }
}

