/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.nio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.MessageList;
import io.netty.channel.nio.AbstractNioChannel;
import java.io.IOException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;

public abstract class AbstractNioMessageChannel
extends AbstractNioChannel {
    protected AbstractNioMessageChannel(Channel parent, Integer id, SelectableChannel ch, int readInterestOp) {
        super(parent, id, ch, readInterestOp);
    }

    @Override
    protected AbstractNioChannel.AbstractNioUnsafe newUnsafe() {
        return new NioMessageUnsafe();
    }

    @Override
    protected int doWrite(MessageList<Object> msgs, int index) throws Exception {
        int writeSpinCount;
        for (int i = writeSpinCount = this.config().getWriteSpinCount() - 1; i >= 0; --i) {
            int written = this.doWriteMessages(msgs, index, i == 0);
            if (written <= 0) continue;
            return written;
        }
        return 0;
    }

    protected abstract int doReadMessages(MessageList<Object> var1) throws Exception;

    protected abstract int doWriteMessages(MessageList<Object> var1, int var2, boolean var3) throws Exception;

    private final class NioMessageUnsafe
    extends AbstractNioChannel.AbstractNioUnsafe {
        private NioMessageUnsafe() {
        }

        @Override
        public void read() {
            int interestOps;
            assert (AbstractNioMessageChannel.this.eventLoop().inEventLoop());
            SelectionKey key = AbstractNioMessageChannel.this.selectionKey();
            if (!AbstractNioMessageChannel.this.config().isAutoRead() && ((interestOps = key.interestOps()) & AbstractNioMessageChannel.this.readInterestOp) != 0) {
                key.interestOps(interestOps & ~AbstractNioMessageChannel.this.readInterestOp);
            }
            ChannelConfig config = AbstractNioMessageChannel.this.config();
            int maxMessagesPerRead = config.getMaxMessagesPerRead();
            boolean autoRead = config.isAutoRead();
            ChannelPipeline pipeline = AbstractNioMessageChannel.this.pipeline();
            boolean closed = false;
            MessageList<Object> msgBuf = MessageList.newInstance();
            Throwable exception = null;
            int readMessages = 0;
            try {
                int localRead;
                while ((localRead = AbstractNioMessageChannel.this.doReadMessages(msgBuf)) != 0) {
                    if (localRead < 0) {
                        closed = true;
                    } else if (!((readMessages += localRead) >= maxMessagesPerRead | !autoRead)) continue;
                    break;
                }
            }
            catch (Throwable t) {
                exception = t;
            }
            pipeline.fireMessageReceived(msgBuf);
            if (exception != null) {
                if (exception instanceof IOException) {
                    closed = true;
                }
                pipeline.fireExceptionCaught(exception);
            }
            if (closed) {
                if (AbstractNioMessageChannel.this.isOpen()) {
                    this.close(this.voidPromise());
                }
            } else {
                pipeline.fireChannelReadSuspended();
            }
        }
    }
}

