/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.oio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.MessageList;
import io.netty.channel.oio.AbstractOioChannel;
import java.io.IOException;

public abstract class AbstractOioMessageChannel
extends AbstractOioChannel {
    protected AbstractOioMessageChannel(Channel parent, Integer id) {
        super(parent, id);
    }

    @Override
    protected void doRead() {
        ChannelPipeline pipeline = this.pipeline();
        boolean closed = false;
        MessageList<Object> msgs = MessageList.newInstance();
        Throwable exception = null;
        try {
            int localReadAmount = this.doReadMessages(msgs);
            if (localReadAmount < 0) {
                closed = true;
            }
        }
        catch (Throwable t) {
            exception = t;
        }
        pipeline.fireMessageReceived(msgs);
        if (exception != null) {
            if (exception instanceof IOException) {
                closed = true;
            }
            this.pipeline().fireExceptionCaught(exception);
        }
        if (closed) {
            if (this.isOpen()) {
                this.unsafe().close(this.unsafe().voidPromise());
            }
        } else {
            pipeline.fireChannelReadSuspended();
        }
    }

    protected abstract int doReadMessages(MessageList<Object> var1) throws Exception;
}

