/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.scheduler;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import gnu.trove.TCollections;
import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.scheduler.ScheduledTask;
import net.md_5.bungee.api.scheduler.TaskScheduler;
import net.md_5.bungee.scheduler.BungeeTask;

public class BungeeScheduler
implements TaskScheduler {
    private final ExecutorService s = Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("Bungee Pool Thread #%1$d").build());
    private final AtomicInteger taskCounter = new AtomicInteger();
    private final TIntObjectMap<BungeeTask> tasks = TCollections.synchronizedMap(new TIntObjectHashMap());
    private final Multimap<Plugin, BungeeTask> tasksByPlugin = Multimaps.synchronizedMultimap(HashMultimap.create());

    public void shutdown() {
        this.s.shutdown();
    }

    @Override
    public void cancel(int id) {
        BungeeTask task = this.tasks.remove(id);
        this.tasksByPlugin.values().remove(task);
    }

    @Override
    public void cancel(ScheduledTask task) {
        this.cancel(task.getId());
    }

    @Override
    public int cancel(Plugin plugin) {
        HashSet<ScheduledTask> toRemove = new HashSet<ScheduledTask>();
        for (ScheduledTask scheduledTask : this.tasksByPlugin.get(plugin)) {
            toRemove.add(scheduledTask);
        }
        for (ScheduledTask scheduledTask : toRemove) {
            this.cancel(scheduledTask);
        }
        return toRemove.size();
    }

    @Override
    public ScheduledTask runAsync(Plugin owner, Runnable task) {
        return this.schedule(owner, task, 0L, TimeUnit.MILLISECONDS);
    }

    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, TimeUnit unit) {
        return this.schedule(owner, task, delay, 0L, unit);
    }

    @Override
    public ScheduledTask schedule(Plugin owner, Runnable task, long delay, long period, TimeUnit unit) {
        Preconditions.checkNotNull(owner, "owner");
        Preconditions.checkNotNull(task, "task");
        BungeeTask prepared = new BungeeTask(this, this.taskCounter.getAndIncrement(), owner, task, delay, period, unit);
        this.tasks.put(prepared.getId(), prepared);
        this.s.execute(prepared);
        return prepared;
    }
}

