/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class BanEntry {
    public static final SimpleDateFormat a = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    public static Logger b = Logger.getLogger("Minecraft");
    private final String c;
    private Date d = new Date();
    private String e = "(Unknown)";
    private Date f = null;
    private String g = "Banned by an operator.";

    public BanEntry(String string) {
        this.c = string;
    }

    public String getName() {
        return this.c;
    }

    public Date getCreated() {
        return this.d;
    }

    public void setCreated(Date date) {
        this.d = date != null ? date : new Date();
    }

    public String getSource() {
        return this.e;
    }

    public void setSource(String string) {
        this.e = string;
    }

    public Date getExpires() {
        return this.f;
    }

    public void setExpires(Date date) {
        this.f = date;
    }

    public boolean hasExpired() {
        if (this.f == null) {
            return false;
        }
        return this.f.before(new Date());
    }

    public String getReason() {
        return this.g;
    }

    public void setReason(String string) {
        this.g = string;
    }

    public String g() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getName());
        stringBuilder.append("|");
        stringBuilder.append(a.format(this.getCreated()));
        stringBuilder.append("|");
        stringBuilder.append(this.getSource());
        stringBuilder.append("|");
        stringBuilder.append(this.getExpires() == null ? "Forever" : a.format(this.getExpires()));
        stringBuilder.append("|");
        stringBuilder.append(this.getReason());
        return stringBuilder.toString();
    }

    public static BanEntry c(String string) {
        if (string.trim().length() < 2) {
            return null;
        }
        String[] stringArray = string.trim().split(Pattern.quote("|"), 5);
        BanEntry banEntry = new BanEntry(stringArray[0].trim());
        int n = 0;
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        try {
            banEntry.setCreated(a.parse(stringArray[n].trim()));
        }
        catch (ParseException parseException) {
            b.log(Level.WARNING, "Could not read creation date format for ban entry '" + banEntry.getName() + "' (was: '" + stringArray[n] + "')", parseException);
        }
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        banEntry.setSource(stringArray[n].trim());
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        try {
            String string2 = stringArray[n].trim();
            if (!string2.equalsIgnoreCase("Forever") && string2.length() > 0) {
                banEntry.setExpires(a.parse(string2));
            }
        }
        catch (ParseException parseException) {
            b.log(Level.WARNING, "Could not read expiry date format for ban entry '" + banEntry.getName() + "' (was: '" + stringArray[n] + "')", parseException);
        }
        if (stringArray.length <= ++n) {
            return banEntry;
        }
        banEntry.setReason(stringArray[n].trim());
        return banEntry;
    }
}

