/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.server.AchievementList;
import net.minecraft.server.Chunk;
import net.minecraft.server.ChunkCoordIntPair;
import net.minecraft.server.ChunkCoordinates;
import net.minecraft.server.Container;
import net.minecraft.server.ContainerBrewingStand;
import net.minecraft.server.ContainerChest;
import net.minecraft.server.ContainerDispenser;
import net.minecraft.server.ContainerEnchantTable;
import net.minecraft.server.ContainerFurnace;
import net.minecraft.server.ContainerMerchant;
import net.minecraft.server.ContainerWorkbench;
import net.minecraft.server.DamageSource;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityArrow;
import net.minecraft.server.EntityDamageSource;
import net.minecraft.server.EntityExperienceOrb;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityItem;
import net.minecraft.server.EntityTracker;
import net.minecraft.server.EnumAnimation;
import net.minecraft.server.EnumBedResult;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ICrafting;
import net.minecraft.server.IInventory;
import net.minecraft.server.IMerchant;
import net.minecraft.server.InventoryMerchant;
import net.minecraft.server.Item;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.ItemStack;
import net.minecraft.server.ItemWorldMapBase;
import net.minecraft.server.LocaleLanguage;
import net.minecraft.server.MerchantRecipeList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.MobEffect;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.NetServerHandler;
import net.minecraft.server.Packet;
import net.minecraft.server.Packet100OpenWindow;
import net.minecraft.server.Packet101CloseWindow;
import net.minecraft.server.Packet103SetSlot;
import net.minecraft.server.Packet104WindowItems;
import net.minecraft.server.Packet105CraftProgressBar;
import net.minecraft.server.Packet17EntityLocationAction;
import net.minecraft.server.Packet18ArmAnimation;
import net.minecraft.server.Packet200Statistic;
import net.minecraft.server.Packet202Abilities;
import net.minecraft.server.Packet204LocaleAndViewDistance;
import net.minecraft.server.Packet22Collect;
import net.minecraft.server.Packet250CustomPayload;
import net.minecraft.server.Packet29DestroyEntity;
import net.minecraft.server.Packet38EntityStatus;
import net.minecraft.server.Packet39AttachEntity;
import net.minecraft.server.Packet3Chat;
import net.minecraft.server.Packet41MobEffect;
import net.minecraft.server.Packet42RemoveMobEffect;
import net.minecraft.server.Packet43SetExperience;
import net.minecraft.server.Packet56MapChunkBulk;
import net.minecraft.server.Packet5EntityEquipment;
import net.minecraft.server.Packet70Bed;
import net.minecraft.server.Packet8UpdateHealth;
import net.minecraft.server.SlotResult;
import net.minecraft.server.Statistic;
import net.minecraft.server.TileEntity;
import net.minecraft.server.TileEntityBrewingStand;
import net.minecraft.server.TileEntityDispenser;
import net.minecraft.server.TileEntityFurnace;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;

public class EntityPlayer
extends EntityHuman
implements ICrafting {
    private LocaleLanguage locale = new LocaleLanguage("en_US");
    public NetServerHandler netServerHandler;
    public MinecraftServer server;
    public ItemInWorldManager itemInWorldManager;
    public double d;
    public double e;
    public final List chunkCoordIntPairQueue = new LinkedList();
    public final List g = new LinkedList();
    private int ch = -99999999;
    private int ci = -99999999;
    private boolean cj = true;
    private int lastSentExp = -99999999;
    private int invulnerableTicks = 60;
    private int cm = 0;
    private int cn = 0;
    private boolean co = true;
    private ItemStack[] cp = new ItemStack[]{null, null, null, null, null};
    private int containerCounter = 0;
    public boolean h;
    public int ping;
    public boolean viewingCredits = false;

    public EntityPlayer(MinecraftServer minecraftServer, World world, String string, ItemInWorldManager itemInWorldManager) {
        super(world);
        itemInWorldManager.player = this;
        this.itemInWorldManager = itemInWorldManager;
        this.cm = minecraftServer.getServerConfigurationManager().o();
        ChunkCoordinates chunkCoordinates = world.getSpawn();
        int n = chunkCoordinates.x;
        int n2 = chunkCoordinates.z;
        int n3 = chunkCoordinates.y;
        if (!world.worldProvider.e && world.getWorldData().getGameType() != EnumGamemode.ADVENTURE) {
            n3 = world.h(n += this.random.nextInt(20) - 10, n2);
            n2 += this.random.nextInt(20) - 10;
        }
        this.setPositionRotation((double)n + 0.5, n3, (double)n2 + 0.5, 0.0f, 0.0f);
        this.server = minecraftServer;
        this.W = 0.0f;
        this.name = string;
        this.height = 0.0f;
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        if (nBTTagCompound.hasKey("playerGameType")) {
            this.itemInWorldManager.setGameMode(EnumGamemode.a(nBTTagCompound.getInt("playerGameType")));
        }
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setInt("playerGameType", this.itemInWorldManager.getGameMode().a());
    }

    public void levelDown(int n) {
        super.levelDown(n);
        this.lastSentExp = -1;
    }

    public void syncInventory() {
        this.activeContainer.addSlotListener(this);
    }

    public ItemStack[] getEquipment() {
        return this.cp;
    }

    protected void d_() {
        this.height = 0.0f;
    }

    public float getHeadHeight() {
        return 1.62f;
    }

    public void h_() {
        Object object;
        Object object2;
        int n;
        this.itemInWorldManager.a();
        --this.invulnerableTicks;
        this.activeContainer.b();
        for (n = 0; n < 5; ++n) {
            object2 = this.b(n);
            if (object2 == this.cp[n]) continue;
            this.q().getTracker().a(this, new Packet5EntityEquipment(this.id, n, (ItemStack)object2));
            this.cp[n] = object2;
        }
        if (!this.chunkCoordIntPairQueue.isEmpty()) {
            Object object3;
            ArrayList<Chunk> arrayList = new ArrayList<Chunk>();
            object2 = this.chunkCoordIntPairQueue.iterator();
            object = new ArrayList();
            while (object2.hasNext() && arrayList.size() < 5) {
                object3 = (ChunkCoordIntPair)object2.next();
                object2.remove();
                if (object3 == null || !this.world.isLoaded(((ChunkCoordIntPair)object3).x << 4, 0, ((ChunkCoordIntPair)object3).z << 4)) continue;
                arrayList.add(this.world.getChunkAt(((ChunkCoordIntPair)object3).x, ((ChunkCoordIntPair)object3).z));
                object.addAll(((WorldServer)this.world).getTileEntities(((ChunkCoordIntPair)object3).x * 16, 0, ((ChunkCoordIntPair)object3).z * 16, ((ChunkCoordIntPair)object3).x * 16 + 16, 256, ((ChunkCoordIntPair)object3).z * 16 + 16));
            }
            if (!arrayList.isEmpty()) {
                this.netServerHandler.sendPacket(new Packet56MapChunkBulk(arrayList));
                object3 = object.iterator();
                while (object3.hasNext()) {
                    TileEntity tileEntity = (TileEntity)object3.next();
                    this.a(tileEntity);
                }
            }
        }
        if (!this.g.isEmpty()) {
            n = Math.min(this.g.size(), 127);
            object2 = new int[n];
            object = this.g.iterator();
            int n2 = 0;
            while (object.hasNext() && n2 < n) {
                object2[n2++] = (Integer)object.next();
                object.remove();
            }
            this.netServerHandler.sendPacket(new Packet29DestroyEntity((int[])object2));
        }
    }

    public void g() {
        int n;
        super.h_();
        for (n = 0; n < this.inventory.getSize(); ++n) {
            Packet packet;
            ItemStack itemStack = this.inventory.getItem(n);
            if (itemStack == null || !Item.byId[itemStack.id].m_() || this.netServerHandler.lowPriorityCount() > 2 || (packet = ((ItemWorldMapBase)Item.byId[itemStack.id]).c(itemStack, this.world, this)) == null) continue;
            this.netServerHandler.sendPacket(packet);
        }
        if (this.bX) {
            if (this.server.getAllowNether()) {
                if (this.activeContainer != this.defaultContainer) {
                    this.closeInventory();
                }
                if (this.vehicle != null) {
                    this.mount(this.vehicle);
                } else {
                    this.bY += 0.0125f;
                    if (this.bY >= 1.0f) {
                        this.bY = 1.0f;
                        this.bW = 10;
                        n = 0;
                        n = this.dimension == -1 ? 0 : -1;
                        this.server.getServerConfigurationManager().changeDimension(this, n);
                        this.lastSentExp = -1;
                        this.ch = -1;
                        this.ci = -1;
                        this.a(AchievementList.x);
                    }
                }
                this.bX = false;
            }
        } else {
            if (this.bY > 0.0f) {
                this.bY -= 0.05f;
            }
            if (this.bY < 0.0f) {
                this.bY = 0.0f;
            }
        }
        if (this.bW > 0) {
            --this.bW;
        }
        if (this.getHealth() != this.ch || this.ci != this.foodData.a() || this.foodData.e() == 0.0f != this.cj) {
            this.netServerHandler.sendPacket(new Packet8UpdateHealth(this.getHealth(), this.foodData.a(), this.foodData.e()));
            this.ch = this.getHealth();
            this.ci = this.foodData.a();
            boolean bl = this.cj = this.foodData.e() == 0.0f;
        }
        if (this.expTotal != this.lastSentExp) {
            this.lastSentExp = this.expTotal;
            this.netServerHandler.sendPacket(new Packet43SetExperience(this.exp, this.expTotal, this.expLevel));
        }
    }

    public ItemStack b(int n) {
        if (n == 0) {
            return this.inventory.getItemInHand();
        }
        return this.inventory.armor[n - 1];
    }

    public void die(DamageSource damageSource) {
        this.server.getServerConfigurationManager().sendAll(new Packet3Chat(damageSource.getLocalizedDeathMessage(this)));
        this.inventory.m();
    }

    public boolean damageEntity(DamageSource damageSource, int n) {
        if (this.invulnerableTicks > 0) {
            return false;
        }
        if (!this.server.getPvP() && damageSource instanceof EntityDamageSource) {
            Entity entity = damageSource.getEntity();
            if (entity instanceof EntityHuman) {
                return false;
            }
            if (entity instanceof EntityArrow) {
                EntityArrow entityArrow = (EntityArrow)entity;
                if (entityArrow.shooter instanceof EntityHuman) {
                    return false;
                }
            }
        }
        return super.damageEntity(damageSource, n);
    }

    protected boolean h() {
        return this.server.getPvP();
    }

    public void c(int n) {
        if (this.dimension == 1 && n == 1) {
            this.a(AchievementList.C);
            this.world.kill(this);
            this.viewingCredits = true;
            this.netServerHandler.sendPacket(new Packet70Bed(4, 0));
        } else {
            this.a(AchievementList.B);
            ChunkCoordinates chunkCoordinates = this.server.getWorldServer(n).getDimensionSpawn();
            if (chunkCoordinates != null) {
                this.netServerHandler.a(chunkCoordinates.x, chunkCoordinates.y, chunkCoordinates.z, 0.0f, 0.0f);
            }
            this.server.getServerConfigurationManager().changeDimension(this, 1);
            this.lastSentExp = -1;
            this.ch = -1;
            this.ci = -1;
        }
    }

    private void a(TileEntity tileEntity) {
        Packet packet;
        if (tileEntity != null && (packet = tileEntity.e()) != null) {
            this.netServerHandler.sendPacket(packet);
        }
    }

    public void receive(Entity entity, int n) {
        if (!entity.dead) {
            EntityTracker entityTracker = this.q().getTracker();
            if (entity instanceof EntityItem) {
                entityTracker.a(entity, new Packet22Collect(entity.id, this.id));
            }
            if (entity instanceof EntityArrow) {
                entityTracker.a(entity, new Packet22Collect(entity.id, this.id));
            }
            if (entity instanceof EntityExperienceOrb) {
                entityTracker.a(entity, new Packet22Collect(entity.id, this.id));
            }
        }
        super.receive(entity, n);
        this.activeContainer.b();
    }

    public void i() {
        if (!this.bH) {
            this.bI = -1;
            this.bH = true;
            this.q().getTracker().a(this, new Packet18ArmAnimation(this, 1));
        }
    }

    public EnumBedResult a(int n, int n2, int n3) {
        EnumBedResult enumBedResult = super.a(n, n2, n3);
        if (enumBedResult == EnumBedResult.OK) {
            Packet17EntityLocationAction packet17EntityLocationAction = new Packet17EntityLocationAction(this, 0, n, n2, n3);
            this.q().getTracker().a(this, packet17EntityLocationAction);
            this.netServerHandler.a(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
            this.netServerHandler.sendPacket(packet17EntityLocationAction);
        }
        return enumBedResult;
    }

    public void a(boolean bl, boolean bl2, boolean bl3) {
        if (this.isSleeping()) {
            this.q().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(this, 3));
        }
        super.a(bl, bl2, bl3);
        if (this.netServerHandler != null) {
            this.netServerHandler.a(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
        }
    }

    public void mount(Entity entity) {
        super.mount(entity);
        this.netServerHandler.sendPacket(new Packet39AttachEntity(this, this.vehicle));
        this.netServerHandler.a(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
    }

    protected void a(double d, boolean bl) {
    }

    public void b(double d, boolean bl) {
        super.a(d, bl);
    }

    private void nextContainerCounter() {
        this.containerCounter = this.containerCounter % 100 + 1;
    }

    public void startCrafting(int n, int n2, int n3) {
        this.nextContainerCounter();
        this.netServerHandler.sendPacket(new Packet100OpenWindow(this.containerCounter, 1, "Crafting", 9));
        this.activeContainer = new ContainerWorkbench(this.inventory, this.world, n, n2, n3);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    public void startEnchanting(int n, int n2, int n3) {
        this.nextContainerCounter();
        this.netServerHandler.sendPacket(new Packet100OpenWindow(this.containerCounter, 4, "Enchanting", 9));
        this.activeContainer = new ContainerEnchantTable(this.inventory, this.world, n, n2, n3);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    public void openContainer(IInventory iInventory) {
        if (this.activeContainer != this.defaultContainer) {
            this.closeInventory();
        }
        this.nextContainerCounter();
        this.netServerHandler.sendPacket(new Packet100OpenWindow(this.containerCounter, 0, iInventory.getName(), iInventory.getSize()));
        this.activeContainer = new ContainerChest(this.inventory, iInventory);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    public void openFurnace(TileEntityFurnace tileEntityFurnace) {
        this.nextContainerCounter();
        this.netServerHandler.sendPacket(new Packet100OpenWindow(this.containerCounter, 2, tileEntityFurnace.getName(), tileEntityFurnace.getSize()));
        this.activeContainer = new ContainerFurnace(this.inventory, tileEntityFurnace);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    public void openDispenser(TileEntityDispenser tileEntityDispenser) {
        this.nextContainerCounter();
        this.netServerHandler.sendPacket(new Packet100OpenWindow(this.containerCounter, 3, tileEntityDispenser.getName(), tileEntityDispenser.getSize()));
        this.activeContainer = new ContainerDispenser(this.inventory, tileEntityDispenser);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    public void openBrewingStand(TileEntityBrewingStand tileEntityBrewingStand) {
        this.nextContainerCounter();
        this.netServerHandler.sendPacket(new Packet100OpenWindow(this.containerCounter, 5, tileEntityBrewingStand.getName(), tileEntityBrewingStand.getSize()));
        this.activeContainer = new ContainerBrewingStand(this.inventory, tileEntityBrewingStand);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
    }

    public void openTrade(IMerchant iMerchant) {
        this.nextContainerCounter();
        this.activeContainer = new ContainerMerchant(this.inventory, iMerchant, this.world);
        this.activeContainer.windowId = this.containerCounter;
        this.activeContainer.addSlotListener(this);
        InventoryMerchant inventoryMerchant = ((ContainerMerchant)this.activeContainer).getMerchantInventory();
        this.netServerHandler.sendPacket(new Packet100OpenWindow(this.containerCounter, 6, inventoryMerchant.getName(), inventoryMerchant.getSize()));
        MerchantRecipeList merchantRecipeList = iMerchant.getOffers(this);
        if (merchantRecipeList != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                dataOutputStream.writeInt(this.containerCounter);
                merchantRecipeList.a(dataOutputStream);
                this.netServerHandler.sendPacket(new Packet250CustomPayload("MC|TrList", byteArrayOutputStream.toByteArray()));
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    public void a(Container container, int n, ItemStack itemStack) {
        if (container.getSlot(n) instanceof SlotResult) {
            return;
        }
        if (this.h) {
            return;
        }
        this.netServerHandler.sendPacket(new Packet103SetSlot(container.windowId, n, itemStack));
    }

    public void updateInventory(Container container) {
        this.a(container, container.a());
    }

    public void a(Container container, List list) {
        this.netServerHandler.sendPacket(new Packet104WindowItems(container.windowId, list));
        this.netServerHandler.sendPacket(new Packet103SetSlot(-1, -1, this.inventory.getCarried()));
    }

    public void setContainerData(Container container, int n, int n2) {
        this.netServerHandler.sendPacket(new Packet105CraftProgressBar(container.windowId, n, n2));
    }

    public void closeInventory() {
        this.netServerHandler.sendPacket(new Packet101CloseWindow(this.activeContainer.windowId));
        this.l();
    }

    public void broadcastCarriedItem() {
        if (this.h) {
            return;
        }
        this.netServerHandler.sendPacket(new Packet103SetSlot(-1, -1, this.inventory.getCarried()));
    }

    public void l() {
        this.activeContainer.a(this);
        this.activeContainer = this.defaultContainer;
    }

    public void a(Statistic statistic, int n) {
        if (statistic == null) {
            return;
        }
        if (!statistic.f) {
            while (n > 100) {
                this.netServerHandler.sendPacket(new Packet200Statistic(statistic.e, 100));
                n -= 100;
            }
            this.netServerHandler.sendPacket(new Packet200Statistic(statistic.e, n));
        }
    }

    public void m() {
        if (this.vehicle != null) {
            this.mount(this.vehicle);
        }
        if (this.passenger != null) {
            this.passenger.mount(this);
        }
        if (this.sleeping) {
            this.a(true, false, false);
        }
    }

    public void n() {
        this.ch = -99999999;
    }

    public void c(String string) {
        LocaleLanguage localeLanguage = LocaleLanguage.a();
        String string2 = localeLanguage.b(string);
        this.netServerHandler.sendPacket(new Packet3Chat(string2));
    }

    protected void o() {
        this.netServerHandler.sendPacket(new Packet38EntityStatus(this.id, 9));
        super.o();
    }

    public void a(ItemStack itemStack, int n) {
        super.a(itemStack, n);
        if (itemStack != null && itemStack.getItem() != null && itemStack.getItem().b(itemStack) == EnumAnimation.b) {
            this.q().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(this, 5));
        }
    }

    protected void a(MobEffect mobEffect) {
        super.a(mobEffect);
        this.netServerHandler.sendPacket(new Packet41MobEffect(this.id, mobEffect));
    }

    protected void b(MobEffect mobEffect) {
        super.b(mobEffect);
        this.netServerHandler.sendPacket(new Packet41MobEffect(this.id, mobEffect));
    }

    protected void c(MobEffect mobEffect) {
        super.c(mobEffect);
        this.netServerHandler.sendPacket(new Packet42RemoveMobEffect(this.id, mobEffect));
    }

    public void enderTeleportTo(double d, double d2, double d3) {
        this.netServerHandler.a(d, d2, d3, this.yaw, this.pitch);
    }

    public void b(Entity entity) {
        this.q().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(entity, 6));
    }

    public void c(Entity entity) {
        this.q().getTracker().sendPacketToEntity(this, new Packet18ArmAnimation(entity, 7));
    }

    public void updateAbilities() {
        if (this.netServerHandler == null) {
            return;
        }
        this.netServerHandler.sendPacket(new Packet202Abilities(this.abilities));
    }

    public WorldServer q() {
        return (WorldServer)this.world;
    }

    public void a(EnumGamemode enumGamemode) {
        this.itemInWorldManager.setGameMode(enumGamemode);
        this.netServerHandler.sendPacket(new Packet70Bed(3, enumGamemode.a()));
    }

    public void sendMessage(String string) {
        this.netServerHandler.sendPacket(new Packet3Chat(string));
    }

    public boolean b(String string) {
        if ("seed".equals(string) && !this.server.S()) {
            return true;
        }
        if ("tell".equals(string) || "help".equals(string) || "me".equals(string)) {
            return true;
        }
        return this.server.getServerConfigurationManager().isOp(this.name);
    }

    public String r() {
        String string = this.netServerHandler.networkManager.getSocketAddress().toString();
        string = string.substring(string.indexOf("/") + 1);
        string = string.substring(0, string.indexOf(":"));
        return string;
    }

    public void a(Packet204LocaleAndViewDistance packet204LocaleAndViewDistance) {
        int n;
        if (this.locale.b().containsKey(packet204LocaleAndViewDistance.d())) {
            this.locale.a(packet204LocaleAndViewDistance.d());
        }
        if ((n = 256 >> packet204LocaleAndViewDistance.f()) > 3 && n < 15) {
            this.cm = n;
        }
        this.cn = packet204LocaleAndViewDistance.g();
        this.co = packet204LocaleAndViewDistance.h();
        if (this.server.H() && this.server.G().equals(this.name)) {
            this.server.c(packet204LocaleAndViewDistance.i());
        }
    }

    public LocaleLanguage getLocale() {
        return this.locale;
    }

    public int getChatFlags() {
        return this.cn;
    }

    public void a(String string, int n) {
        String string2 = string + "\u0000" + n;
        this.netServerHandler.sendPacket(new Packet250CustomPayload("MC|TPack", string2.getBytes()));
    }
}

