/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;

public final class ChannelOutboundBuffer {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(ChannelOutboundBuffer.class);
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final Recycler<ChannelOutboundBuffer> RECYCLER = new Recycler<ChannelOutboundBuffer>(){

        @Override
        protected ChannelOutboundBuffer newObject(Recycler.Handle handle) {
            return new ChannelOutboundBuffer(handle);
        }
    };
    private final Recycler.Handle handle;
    private AbstractChannel channel;
    private Object[] flushed;
    private ChannelPromise[] flushedPromises;
    private int[] flushedPendingSizes;
    private long[] flushedProgresses;
    private long[] flushedTotals;
    private int head;
    private int tail;
    private ByteBuffer[] nioBuffers;
    private int nioBufferCount;
    private long nioBufferSize;
    private Object[] unflushed;
    private ChannelPromise[] unflushedPromises;
    private int[] unflushedPendingSizes;
    private long[] unflushedTotals;
    private int unflushedCount;
    private boolean inFail;
    private long totalPendingSize;
    private static final AtomicIntegerFieldUpdater<ChannelOutboundBuffer> WRITABLE_UPDATER = AtomicIntegerFieldUpdater.newUpdater(ChannelOutboundBuffer.class, "writable");
    private volatile int writable = 1;

    static ChannelOutboundBuffer newInstance(AbstractChannel channel) {
        ChannelOutboundBuffer buffer = RECYCLER.get();
        buffer.channel = channel;
        return buffer;
    }

    private ChannelOutboundBuffer(Recycler.Handle handle) {
        this(handle, 16);
    }

    private ChannelOutboundBuffer(Recycler.Handle handle, int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("initialCapacity: " + initialCapacity + " (expected: >= 0)");
        }
        if (initialCapacity >= 8) {
            initialCapacity |= initialCapacity >>> 1;
            initialCapacity |= initialCapacity >>> 2;
            initialCapacity |= initialCapacity >>> 4;
            initialCapacity |= initialCapacity >>> 8;
            initialCapacity |= initialCapacity >>> 16;
            if (++initialCapacity < 0) {
                initialCapacity >>>= 1;
            }
        } else {
            initialCapacity = 8;
        }
        this.handle = handle;
        this.flushed = new Object[initialCapacity];
        this.flushedPromises = new ChannelPromise[initialCapacity];
        this.flushedPendingSizes = new int[initialCapacity];
        this.flushedProgresses = new long[initialCapacity];
        this.flushedTotals = new long[initialCapacity];
        this.nioBuffers = new ByteBuffer[initialCapacity];
        this.unflushed = new Object[initialCapacity];
        this.unflushedPromises = new ChannelPromise[initialCapacity];
        this.unflushedPendingSizes = new int[initialCapacity];
        this.unflushedTotals = new long[initialCapacity];
    }

    void recycle() {
        if (this.head != this.tail) {
            throw new IllegalStateException();
        }
        if (this.unflushedCount != 0) {
            throw new IllegalStateException();
        }
        if (this.totalPendingSize != 0L) {
            throw new IllegalStateException();
        }
        RECYCLER.recycle(this, this.handle);
    }

    void addMessage(Object msg, ChannelPromise promise) {
        int unflushedCount = this.unflushedCount;
        Object[] unflushed = this.unflushed;
        if (unflushedCount == unflushed.length - 1) {
            this.doubleUnflushedCapacity();
            unflushed = this.unflushed;
        }
        int size = this.channel.calculateMessageSize(msg);
        unflushed[unflushedCount] = msg;
        this.unflushedPendingSizes[unflushedCount] = size;
        this.unflushedPromises[unflushedCount] = promise;
        this.unflushedTotals[unflushedCount] = ChannelOutboundBuffer.total(msg);
        this.unflushedCount = unflushedCount + 1;
        this.incrementPendingOutboundBytes(size);
    }

    private static long total(Object msg) {
        if (msg instanceof ByteBuf) {
            return ((ByteBuf)msg).readableBytes();
        }
        if (msg instanceof FileRegion) {
            return ((FileRegion)msg).count();
        }
        if (msg instanceof ByteBufHolder) {
            return ((ByteBufHolder)msg).content().readableBytes();
        }
        return -1L;
    }

    private void doubleUnflushedCapacity() {
        int newCapacity = this.unflushed.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException();
        }
        int unflushedCount = this.unflushedCount;
        Object[] a1 = new Object[newCapacity];
        System.arraycopy(this.unflushed, 0, a1, 0, unflushedCount);
        this.unflushed = a1;
        ChannelPromise[] a2 = new ChannelPromise[newCapacity];
        System.arraycopy(this.unflushedPromises, 0, a2, 0, unflushedCount);
        this.unflushedPromises = a2;
        int[] a3 = new int[newCapacity];
        System.arraycopy(this.unflushedPendingSizes, 0, a3, 0, unflushedCount);
        this.unflushedPendingSizes = a3;
        long[] a4 = new long[newCapacity];
        System.arraycopy(this.unflushedTotals, 0, a4, 0, unflushedCount);
        this.unflushedTotals = a4;
    }

    void addFlush() {
        int unflushedCount = this.unflushedCount;
        if (unflushedCount == 0) {
            return;
        }
        Object[] unflushed = this.unflushed;
        Object[] unflushedPromises = this.unflushedPromises;
        int[] unflushedPendingSizes = this.unflushedPendingSizes;
        long[] unflushedTotals = this.unflushedTotals;
        Object[] flushed = this.flushed;
        ChannelPromise[] flushedPromises = this.flushedPromises;
        int[] flushedPendingSizes = this.flushedPendingSizes;
        long[] flushedProgresses = this.flushedProgresses;
        long[] flushedTotals = this.flushedTotals;
        int head = this.head;
        int tail = this.tail;
        for (int i = 0; i < unflushedCount; ++i) {
            flushed[tail] = unflushed[i];
            flushedPromises[tail] = unflushedPromises[i];
            flushedPendingSizes[tail] = unflushedPendingSizes[i];
            flushedProgresses[tail] = 0L;
            flushedTotals[tail] = unflushedTotals[i];
            if ((tail = tail + 1 & flushed.length - 1) != head) continue;
            this.tail = tail;
            this.doubleFlushedCapacity();
            head = this.head;
            tail = this.tail;
            flushed = this.flushed;
            flushedPromises = this.flushedPromises;
            flushedPendingSizes = this.flushedPendingSizes;
            flushedProgresses = this.flushedProgresses;
            flushedTotals = this.flushedTotals;
        }
        Arrays.fill(unflushed, 0, unflushedCount, null);
        Arrays.fill(unflushedPromises, 0, unflushedCount, null);
        this.unflushedCount = 0;
        this.tail = tail;
    }

    private void doubleFlushedCapacity() {
        int p = this.head;
        int n = this.flushed.length;
        int r = n - p;
        int newCapacity = n << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException();
        }
        Object[] a1 = new Object[newCapacity];
        System.arraycopy(this.flushed, p, a1, 0, r);
        System.arraycopy(this.flushed, 0, a1, r, p);
        this.flushed = a1;
        ChannelPromise[] a2 = new ChannelPromise[newCapacity];
        System.arraycopy(this.flushedPromises, p, a2, 0, r);
        System.arraycopy(this.flushedPromises, 0, a2, r, p);
        this.flushedPromises = a2;
        int[] a3 = new int[newCapacity];
        System.arraycopy(this.flushedPendingSizes, p, a3, 0, r);
        System.arraycopy(this.flushedPendingSizes, 0, a3, r, p);
        this.flushedPendingSizes = a3;
        long[] a4 = new long[newCapacity];
        System.arraycopy(this.flushedProgresses, p, a4, 0, r);
        System.arraycopy(this.flushedProgresses, 0, a4, r, p);
        this.flushedProgresses = a4;
        long[] a5 = new long[newCapacity];
        System.arraycopy(this.flushedTotals, p, a5, 0, r);
        System.arraycopy(this.flushedTotals, 0, a5, r, p);
        this.flushedTotals = a5;
        this.head = 0;
        this.tail = n;
    }

    private void incrementPendingOutboundBytes(int size) {
        if (size == 0) {
            return;
        }
        long newWriteBufferSize = this.totalPendingSize += (long)size;
        int highWaterMark = this.channel.config().getWriteBufferHighWaterMark();
        if (newWriteBufferSize > (long)highWaterMark && WRITABLE_UPDATER.compareAndSet(this, 1, 0)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    private void decrementPendingOutboundBytes(int size) {
        if (size == 0) {
            return;
        }
        long newWriteBufferSize = this.totalPendingSize -= (long)size;
        int lowWaterMark = this.channel.config().getWriteBufferLowWaterMark();
        if ((newWriteBufferSize == 0L || newWriteBufferSize < (long)lowWaterMark) && WRITABLE_UPDATER.compareAndSet(this, 0, 1)) {
            this.channel.pipeline().fireChannelWritabilityChanged();
        }
    }

    public Object current() {
        return this.flushed[this.head];
    }

    public void progress(long amount) {
        int head = this.head;
        ChannelPromise p = this.flushedPromises[head];
        if (p instanceof ChannelProgressivePromise) {
            long progress;
            this.flushedProgresses[head] = progress = this.flushedProgresses[head] + amount;
            ((ChannelProgressivePromise)p).tryProgress(progress, this.flushedTotals[head]);
        }
    }

    public boolean remove() {
        int head = this.head;
        Object msg = this.flushed[head];
        if (msg == null) {
            return false;
        }
        ChannelOutboundBuffer.safeRelease(msg);
        this.flushed[head] = null;
        ChannelPromise promise = this.flushedPromises[head];
        promise.trySuccess();
        this.flushedPromises[head] = null;
        int size = this.flushedPendingSizes[head];
        this.flushedPendingSizes[head] = 0;
        this.head = head + 1 & this.flushed.length - 1;
        this.decrementPendingOutboundBytes(size);
        return true;
    }

    public boolean remove(Throwable cause) {
        int head = this.head;
        Object msg = this.flushed[head];
        if (msg == null) {
            return false;
        }
        ChannelOutboundBuffer.safeRelease(msg);
        this.flushed[head] = null;
        ChannelOutboundBuffer.safeFail(this.flushedPromises[head], cause);
        this.flushedPromises[head] = null;
        int size = this.flushedPendingSizes[head];
        this.flushedPendingSizes[head] = 0;
        this.head = head + 1 & this.flushed.length - 1;
        this.decrementPendingOutboundBytes(size);
        return true;
    }

    public ByteBuffer[] nioBuffers() {
        Object m;
        ByteBuffer[] nioBuffers = this.nioBuffers;
        long nioBufferSize = 0L;
        int nioBufferCount = 0;
        int mask = this.flushed.length - 1;
        int i = this.head;
        while ((m = this.flushed[i]) != null) {
            if (!(m instanceof ByteBuf)) {
                this.nioBufferCount = 0;
                this.nioBufferSize = 0L;
                return null;
            }
            ByteBuf buf = (ByteBuf)m;
            int readerIndex = buf.readerIndex();
            int readableBytes = buf.writerIndex() - readerIndex;
            if (readableBytes > 0) {
                nioBufferSize += (long)readableBytes;
                if (buf.isDirect()) {
                    int count = buf.nioBufferCount();
                    if (count == 1) {
                        if (nioBufferCount == nioBuffers.length) {
                            nioBuffers = ChannelOutboundBuffer.doubleNioBufferArray(nioBuffers, nioBufferCount);
                            this.nioBuffers = nioBuffers;
                        }
                        nioBuffers[nioBufferCount++] = buf.internalNioBuffer(readerIndex, readableBytes);
                    } else {
                        ByteBuffer[] nioBufs = buf.nioBuffers();
                        if (nioBufferCount + nioBufs.length == nioBuffers.length + 1) {
                            nioBuffers = ChannelOutboundBuffer.doubleNioBufferArray(nioBuffers, nioBufferCount);
                            this.nioBuffers = nioBuffers;
                        }
                        for (ByteBuffer nioBuf : nioBufs) {
                            if (nioBuf == null) break;
                            nioBuffers[nioBufferCount++] = nioBuf;
                        }
                    }
                } else {
                    ByteBuf directBuf = this.channel.alloc().directBuffer(readableBytes);
                    directBuf.writeBytes(buf, readerIndex, readableBytes);
                    buf.release();
                    this.flushed[i] = directBuf;
                    if (nioBufferCount == nioBuffers.length) {
                        nioBuffers = ChannelOutboundBuffer.doubleNioBufferArray(nioBuffers, nioBufferCount);
                    }
                    nioBuffers[nioBufferCount++] = directBuf.internalNioBuffer(0, readableBytes);
                }
            }
            i = i + 1 & mask;
        }
        this.nioBufferCount = nioBufferCount;
        this.nioBufferSize = nioBufferSize;
        return nioBuffers;
    }

    private static ByteBuffer[] doubleNioBufferArray(ByteBuffer[] array, int size) {
        int newCapacity = array.length << 1;
        if (newCapacity < 0) {
            throw new IllegalStateException();
        }
        ByteBuffer[] newArray = new ByteBuffer[newCapacity];
        System.arraycopy(array, 0, newArray, 0, size);
        return newArray;
    }

    public int nioBufferCount() {
        return this.nioBufferCount;
    }

    public long nioBufferSize() {
        return this.nioBufferSize;
    }

    boolean getWritable() {
        return WRITABLE_UPDATER.get(this) != 0;
    }

    public int size() {
        return this.tail - this.head & this.flushed.length - 1;
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failUnflushed(Throwable cause) {
        if (this.inFail) {
            return;
        }
        this.inFail = true;
        Object[] unflushed = this.unflushed;
        ChannelPromise[] unflushedPromises = this.unflushedPromises;
        int[] unflushedPendingSizes = this.unflushedPendingSizes;
        int unflushedCount = this.unflushedCount;
        try {
            for (int i = 0; i < unflushedCount; ++i) {
                ChannelOutboundBuffer.safeRelease(unflushed[i]);
                unflushed[i] = null;
                ChannelOutboundBuffer.safeFail(unflushedPromises[i], cause);
                unflushedPromises[i] = null;
                this.decrementPendingOutboundBytes(unflushedPendingSizes[i]);
                unflushedPendingSizes[i] = 0;
            }
        }
        finally {
            this.unflushedCount = 0;
            this.inFail = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failFlushed(Throwable cause) {
        if (this.inFail) {
            return;
        }
        try {
            this.inFail = true;
            while (this.remove(cause)) {
            }
        }
        finally {
            this.inFail = false;
        }
    }

    private static void safeRelease(Object message) {
        try {
            ReferenceCountUtil.release(message);
        }
        catch (Throwable t) {
            logger.warn("Failed to release a message.", t);
        }
    }

    private static void safeFail(ChannelPromise promise, Throwable cause) {
        if (!(promise instanceof VoidChannelPromise) && !promise.tryFailure(cause)) {
            logger.warn("Promise done already: {} - new exception is:", (Object)promise, (Object)cause);
        }
    }
}

