/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.plugin;

import com.google.common.io.PatternFilenameFilter;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import net.md_5.bungee.Logger;
import net.md_5.bungee.plugin.InvalidPluginException;
import net.md_5.bungee.plugin.JavaPlugin;
import net.md_5.bungee.plugin.LoginEvent;
import net.md_5.bungee.plugin.PluginDescription;
import net.md_5.bungee.plugin.ServerConnectEvent;

public class JavaPluginManager
extends JavaPlugin {
    private final Set<JavaPlugin> plugins = new HashSet<JavaPlugin>();

    public void loadPlugins() {
        File dir = new File("plugins");
        dir.mkdir();
        for (File file : dir.listFiles(new PatternFilenameFilter(".*\\.jar"))) {
            try {
                PluginDescription description;
                JarFile jar = new JarFile(file);
                ZipEntry entry = jar.getEntry("plugin.yml");
                if (entry == null) {
                    throw new InvalidPluginException("Jar does not contain a plugin.yml");
                }
                try (InputStream is = jar.getInputStream(entry);){
                    description = PluginDescription.load(is);
                }
                URLClassLoader classloader = new URLClassLoader(new URL[]{file.toURI().toURL()}, this.getClass().getClassLoader());
                Class<?> clazz = Class.forName(description.getMain(), true, classloader);
                Class<JavaPlugin> subClazz = clazz.asSubclass(JavaPlugin.class);
                JavaPlugin plugin = subClazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                plugin.description = description;
                plugin.onEnable();
                this.plugins.add(plugin);
                Logger.$().info("Loaded plugin: " + plugin.description.getName());
            }
            catch (Exception ex) {
                Logger.$().severe("Could not load plugin: " + file);
                ex.printStackTrace();
            }
        }
    }

    @Override
    public void onDisable() {
        for (JavaPlugin p : this.plugins) {
            p.onDisable();
        }
    }

    @Override
    public void onHandshake(LoginEvent event) {
        for (JavaPlugin p : this.plugins) {
            p.onHandshake(event);
        }
    }

    @Override
    public void onLogin(LoginEvent event) {
        for (JavaPlugin p : this.plugins) {
            p.onLogin(event);
        }
    }

    @Override
    public void onServerConnect(ServerConnectEvent event) {
        for (JavaPlugin p : this.plugins) {
            p.onServerConnect(event);
        }
    }

    public Set<JavaPlugin> getPlugins() {
        return this.plugins;
    }
}

