/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.protocol.packet;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.util.Arrays;
import net.md_5.bungee.protocol.MinecraftStream;
import net.md_5.bungee.protocol.packet.AbstractPacketHandler;
import net.md_5.bungee.protocol.packet.DefinedPacket;

public class PacketFAPluginMessage
extends DefinedPacket {
    private String tag;
    private byte[] data;

    private PacketFAPluginMessage() {
        super(250);
    }

    public PacketFAPluginMessage(String tag, byte[] data) {
        this();
        this.tag = tag;
        this.data = data;
    }

    @Override
    public void read(ByteBuf buf) {
        this.tag = this.readString(buf);
        this.data = this.readArray(buf);
    }

    @Override
    public void write(ByteBuf buf) {
        this.writeString(this.tag, buf);
        this.writeArray(this.data, buf);
    }

    @Override
    public void handle(AbstractPacketHandler handler) throws Exception {
        handler.handle(this);
    }

    public DataInput getStream() {
        return new DataInputStream(new ByteArrayInputStream(this.data));
    }

    public MinecraftStream getMCStream() {
        return new MinecraftStream(Unpooled.wrappedBuffer(this.data));
    }

    public String getTag() {
        return this.tag;
    }

    public byte[] getData() {
        return this.data;
    }

    @Override
    public String toString() {
        return "PacketFAPluginMessage(tag=" + this.getTag() + ", data=" + Arrays.toString(this.getData()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PacketFAPluginMessage)) {
            return false;
        }
        PacketFAPluginMessage other = (PacketFAPluginMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$tag = this.getTag();
        String other$tag = other.getTag();
        if (this$tag == null ? other$tag != null : !this$tag.equals(other$tag)) {
            return false;
        }
        return Arrays.equals(this.getData(), other.getData());
    }

    public boolean canEqual(Object other) {
        return other instanceof PacketFAPluginMessage;
    }

    @Override
    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        String $tag = this.getTag();
        result = result * 31 + ($tag == null ? 0 : $tag.hashCode());
        result = result * 31 + Arrays.hashCode(this.getData());
        return result;
    }
}

