/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.embedded;

import io.netty.channel.AbstractChannel;
import io.netty.channel.ChannelConfig;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelMetadata;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelConfig;
import io.netty.channel.EventLoop;
import io.netty.channel.MessageList;
import io.netty.channel.embedded.EmbeddedEventLoop;
import io.netty.channel.embedded.EmbeddedSocketAddress;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;

public class EmbeddedChannel
extends AbstractChannel {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA = new ChannelMetadata(false);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelConfig config = new DefaultChannelConfig(this);
    private final SocketAddress localAddress = new EmbeddedSocketAddress();
    private final SocketAddress remoteAddress = new EmbeddedSocketAddress();
    private final Queue<Object> lastInboundBuffer = new ArrayDeque<Object>();
    private final Queue<Object> lastOutboundBuffer = new ArrayDeque<Object>();
    private Throwable lastException;
    private int state;

    public EmbeddedChannel(ChannelHandler ... handlers) {
        super(null, null);
        if (handlers == null) {
            throw new NullPointerException("handlers");
        }
        int nHandlers = 0;
        ChannelPipeline p = this.pipeline();
        for (ChannelHandler h : handlers) {
            if (h == null) break;
            ++nHandlers;
            p.addLast(h);
        }
        if (nHandlers == 0) {
            throw new IllegalArgumentException("handlers is empty.");
        }
        p.addLast(new LastInboundHandler());
        this.loop.register(this);
    }

    @Override
    public ChannelMetadata metadata() {
        return METADATA;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state < 2;
    }

    @Override
    public boolean isActive() {
        return this.state == 1;
    }

    public Queue<Object> lastInboundBuffer() {
        return this.lastInboundBuffer;
    }

    public Queue<Object> lastOutboundBuffer() {
        return this.lastOutboundBuffer;
    }

    public Object readInbound() {
        return this.lastInboundBuffer.poll();
    }

    public Object readOutbound() {
        return this.lastOutboundBuffer.poll();
    }

    public boolean writeInbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return !this.lastInboundBuffer.isEmpty();
        }
        MessageList<int> list = MessageList.newInstance(msgs.length);
        list.add((int[])msgs);
        this.pipeline().fireMessageReceived(list);
        this.runPendingTasks();
        this.checkException();
        return !this.lastInboundBuffer.isEmpty();
    }

    public boolean writeOutbound(Object ... msgs) {
        this.ensureOpen();
        if (msgs.length == 0) {
            return !this.lastOutboundBuffer.isEmpty();
        }
        MessageList<int> list = MessageList.newInstance(msgs.length);
        list.add((int[])msgs);
        ChannelFuture future = this.write(list);
        assert (future.isDone());
        if (future.cause() != null) {
            this.recordException(future.cause());
        }
        this.runPendingTasks();
        this.checkException();
        return !this.lastOutboundBuffer.isEmpty();
    }

    public boolean finish() {
        this.close();
        this.runPendingTasks();
        this.checkException();
        return !this.lastInboundBuffer.isEmpty() || !this.lastOutboundBuffer.isEmpty();
    }

    public void runPendingTasks() {
        try {
            this.loop.runTasks();
        }
        catch (Exception e) {
            this.recordException(e);
        }
    }

    private void recordException(Throwable cause) {
        if (this.lastException == null) {
            this.lastException = cause;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", cause);
        }
    }

    public void checkException() {
        Throwable t = this.lastException;
        if (t == null) {
            return;
        }
        this.lastException = null;
        PlatformDependent.throwException(t);
    }

    protected final void ensureOpen() {
        if (!this.isOpen()) {
            this.recordException(new ClosedChannelException());
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? this.localAddress : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? this.remoteAddress : null;
    }

    @Override
    protected Runnable doRegister() throws Exception {
        this.state = 1;
        return null;
    }

    @Override
    protected void doBind(SocketAddress localAddress) throws Exception {
    }

    @Override
    protected void doDisconnect() throws Exception {
        this.doClose();
    }

    @Override
    protected void doClose() throws Exception {
        this.state = 2;
    }

    @Override
    protected Runnable doDeregister() throws Exception {
        return null;
    }

    @Override
    protected void doBeginRead() throws Exception {
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultUnsafe();
    }

    @Override
    protected boolean isFlushPending() {
        return false;
    }

    @Override
    protected int doWrite(MessageList<Object> msgs, int index) throws Exception {
        int size = msgs.size();
        for (int i = index; i < size; ++i) {
            this.lastOutboundBuffer.add(msgs.get(i));
        }
        return size - index;
    }

    private final class LastInboundHandler
    extends ChannelInboundHandlerAdapter {
        private LastInboundHandler() {
        }

        @Override
        public void messageReceived(ChannelHandlerContext ctx, MessageList<Object> msgs) throws Exception {
            int size = msgs.size();
            for (int i = 0; i < size; ++i) {
                EmbeddedChannel.this.lastInboundBuffer.add(msgs.get(i));
            }
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            EmbeddedChannel.this.recordException(cause);
        }
    }

    private class DefaultUnsafe
    extends AbstractChannel.AbstractUnsafe {
        private DefaultUnsafe() {
        }

        @Override
        public void connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            promise.setSuccess();
        }
    }
}

