/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import net.minecraft.server.AchievementList;
import net.minecraft.server.EntityAnimal;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityPigZombie;
import net.minecraft.server.Item;
import net.minecraft.server.NBTTagCompound;
import net.minecraft.server.PathfinderGoalBreed;
import net.minecraft.server.PathfinderGoalFloat;
import net.minecraft.server.PathfinderGoalFollowParent;
import net.minecraft.server.PathfinderGoalLookAtPlayer;
import net.minecraft.server.PathfinderGoalPanic;
import net.minecraft.server.PathfinderGoalRandomLookaround;
import net.minecraft.server.PathfinderGoalRandomStroll;
import net.minecraft.server.PathfinderGoalTempt;
import net.minecraft.server.World;

public class EntityPig
extends EntityAnimal {
    public EntityPig(World world) {
        super(world);
        this.texture = "/mob/pig.png";
        this.a(0.9f, 0.9f);
        this.getNavigation().a(true);
        float f = 0.25f;
        this.goalSelector.a(0, new PathfinderGoalFloat(this));
        this.goalSelector.a(1, new PathfinderGoalPanic(this, 0.38f));
        this.goalSelector.a(2, new PathfinderGoalBreed(this, f));
        this.goalSelector.a(3, new PathfinderGoalTempt(this, 0.25f, Item.WHEAT.id, false));
        this.goalSelector.a(4, new PathfinderGoalFollowParent(this, 0.28f));
        this.goalSelector.a(5, new PathfinderGoalRandomStroll(this, f));
        this.goalSelector.a(6, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 6.0f));
        this.goalSelector.a(7, new PathfinderGoalRandomLookaround(this));
    }

    public boolean aV() {
        return true;
    }

    public int getMaxHealth() {
        return 10;
    }

    protected void a() {
        super.a();
        this.datawatcher.a(16, (byte)0);
    }

    public void b(NBTTagCompound nBTTagCompound) {
        super.b(nBTTagCompound);
        nBTTagCompound.setBoolean("Saddle", this.hasSaddle());
    }

    public void a(NBTTagCompound nBTTagCompound) {
        super.a(nBTTagCompound);
        this.setSaddle(nBTTagCompound.getBoolean("Saddle"));
    }

    protected String aQ() {
        return "mob.pig";
    }

    protected String aR() {
        return "mob.pig";
    }

    protected String aS() {
        return "mob.pigdeath";
    }

    public boolean c(EntityHuman entityHuman) {
        if (!super.c(entityHuman)) {
            if (this.hasSaddle() && !this.world.isStatic && (this.passenger == null || this.passenger == entityHuman)) {
                entityHuman.mount(this);
                return true;
            }
            return false;
        }
        return true;
    }

    protected int getLootId() {
        if (this.isBurning()) {
            return Item.GRILLED_PORK.id;
        }
        return Item.PORK.id;
    }

    protected void dropDeathLoot(boolean bl, int n) {
        int n2 = this.random.nextInt(3) + 1 + this.random.nextInt(1 + n);
        for (int i = 0; i < n2; ++i) {
            if (this.isBurning()) {
                this.b(Item.GRILLED_PORK.id, 1);
                continue;
            }
            this.b(Item.PORK.id, 1);
        }
    }

    public boolean hasSaddle() {
        return (this.datawatcher.getByte(16) & 1) != 0;
    }

    public void setSaddle(boolean bl) {
        if (bl) {
            this.datawatcher.watch(16, (byte)1);
        } else {
            this.datawatcher.watch(16, (byte)0);
        }
    }

    public void a(EntityLightning entityLightning) {
        if (this.world.isStatic) {
            return;
        }
        EntityPigZombie entityPigZombie = new EntityPigZombie(this.world);
        entityPigZombie.setPositionRotation(this.locX, this.locY, this.locZ, this.yaw, this.pitch);
        this.world.addEntity(entityPigZombie);
        this.die();
    }

    protected void a(float f) {
        super.a(f);
        if (f > 5.0f && this.passenger instanceof EntityHuman) {
            ((EntityHuman)this.passenger).a(AchievementList.u);
        }
    }

    public EntityAnimal createChild(EntityAnimal entityAnimal) {
        return new EntityPig(this.world);
    }
}

