/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.server.BiomeBeach;
import net.minecraft.server.BiomeBigHills;
import net.minecraft.server.BiomeDecorator;
import net.minecraft.server.BiomeDesert;
import net.minecraft.server.BiomeForest;
import net.minecraft.server.BiomeHell;
import net.minecraft.server.BiomeIcePlains;
import net.minecraft.server.BiomeJungle;
import net.minecraft.server.BiomeMeta;
import net.minecraft.server.BiomeMushrooms;
import net.minecraft.server.BiomeOcean;
import net.minecraft.server.BiomePlains;
import net.minecraft.server.BiomeRiver;
import net.minecraft.server.BiomeSwamp;
import net.minecraft.server.BiomeTaiga;
import net.minecraft.server.BiomeTheEnd;
import net.minecraft.server.Block;
import net.minecraft.server.EntityChicken;
import net.minecraft.server.EntityCow;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityEnderman;
import net.minecraft.server.EntityPig;
import net.minecraft.server.EntitySheep;
import net.minecraft.server.EntitySkeleton;
import net.minecraft.server.EntitySlime;
import net.minecraft.server.EntitySpider;
import net.minecraft.server.EntitySquid;
import net.minecraft.server.EntityZombie;
import net.minecraft.server.EnumCreatureType;
import net.minecraft.server.World;
import net.minecraft.server.WorldGenBigTree;
import net.minecraft.server.WorldGenForest;
import net.minecraft.server.WorldGenGrass;
import net.minecraft.server.WorldGenSwampTree;
import net.minecraft.server.WorldGenTrees;
import net.minecraft.server.WorldGenerator;

public abstract class BiomeBase {
    public static final BiomeBase[] biomes = new BiomeBase[256];
    public static final BiomeBase OCEAN = new BiomeOcean(0).b(112).a("Ocean").b(-1.0f, 0.4f);
    public static final BiomeBase PLAINS = new BiomePlains(1).b(9286496).a("Plains").a(0.8f, 0.4f);
    public static final BiomeBase DESERT = new BiomeDesert(2).b(16421912).a("Desert").m().a(2.0f, 0.0f).b(0.1f, 0.2f);
    public static final BiomeBase EXTREME_HILLS = new BiomeBigHills(3).b(0x606060).a("Extreme Hills").b(0.3f, 1.5f).a(0.2f, 0.3f);
    public static final BiomeBase FOREST = new BiomeForest(4).b(353825).a("Forest").a(5159473).a(0.7f, 0.8f);
    public static final BiomeBase TAIGA = new BiomeTaiga(5).b(747097).a("Taiga").a(5159473).b().a(0.05f, 0.8f).b(0.1f, 0.4f);
    public static final BiomeBase SWAMPLAND = new BiomeSwamp(6).b(522674).a("Swampland").a(9154376).b(-0.2f, 0.1f).a(0.8f, 0.9f);
    public static final BiomeBase RIVER = new BiomeRiver(7).b(255).a("River").b(-0.5f, 0.0f);
    public static final BiomeBase HELL = new BiomeHell(8).b(0xFF0000).a("Hell").m().a(2.0f, 0.0f);
    public static final BiomeBase SKY = new BiomeTheEnd(9).b(0x8080FF).a("Sky").m();
    public static final BiomeBase FROZEN_OCEAN = new BiomeOcean(10).b(0x9090A0).a("FrozenOcean").b().b(-1.0f, 0.5f).a(0.0f, 0.5f);
    public static final BiomeBase FROZEN_RIVER = new BiomeRiver(11).b(0xA0A0FF).a("FrozenRiver").b().b(-0.5f, 0.0f).a(0.0f, 0.5f);
    public static final BiomeBase ICE_PLAINS = new BiomeIcePlains(12).b(0xFFFFFF).a("Ice Plains").b().a(0.0f, 0.5f);
    public static final BiomeBase ICE_MOUNTAINS = new BiomeIcePlains(13).b(0xA0A0A0).a("Ice Mountains").b().b(0.3f, 1.3f).a(0.0f, 0.5f);
    public static final BiomeBase MUSHROOM_ISLAND = new BiomeMushrooms(14).b(0xFF00FF).a("MushroomIsland").a(0.9f, 1.0f).b(0.2f, 1.0f);
    public static final BiomeBase MUSHROOM_SHORE = new BiomeMushrooms(15).b(0xA000FF).a("MushroomIslandShore").a(0.9f, 1.0f).b(-1.0f, 0.1f);
    public static final BiomeBase BEACH = new BiomeBeach(16).b(16440917).a("Beach").a(0.8f, 0.4f).b(0.0f, 0.1f);
    public static final BiomeBase DESERT_HILLS = new BiomeDesert(17).b(13786898).a("DesertHills").m().a(2.0f, 0.0f).b(0.3f, 0.8f);
    public static final BiomeBase FOREST_HILLS = new BiomeForest(18).b(2250012).a("ForestHills").a(5159473).a(0.7f, 0.8f).b(0.3f, 0.7f);
    public static final BiomeBase TAIGA_HILLS = new BiomeTaiga(19).b(1456435).a("TaigaHills").b().a(5159473).a(0.05f, 0.8f).b(0.3f, 0.8f);
    public static final BiomeBase SMALL_MOUNTAINS = new BiomeBigHills(20).b(7501978).a("Extreme Hills Edge").b(0.2f, 0.8f).a(0.2f, 0.3f);
    public static final BiomeBase JUNGLE = new BiomeJungle(21).b(5470985).a("Jungle").a(5470985).a(1.2f, 0.9f).b(0.2f, 0.4f);
    public static final BiomeBase JUNGLE_HILLS = new BiomeJungle(22).b(2900485).a("JungleHills").a(5470985).a(1.2f, 0.9f).b(1.8f, 0.5f);
    public String y;
    public int z;
    public byte A;
    public byte B;
    public int C;
    public float D;
    public float E;
    public float temperature;
    public float humidity;
    public int H;
    public BiomeDecorator I;
    protected List J;
    protected List K;
    protected List L;
    private boolean R;
    private boolean S;
    public final int id;
    protected WorldGenTrees N;
    protected WorldGenBigTree O;
    protected WorldGenForest P;
    protected WorldGenSwampTree Q;

    protected BiomeBase(int n) {
        this.A = (byte)Block.GRASS.id;
        this.B = (byte)Block.DIRT.id;
        this.C = 5169201;
        this.D = 0.1f;
        this.E = 0.3f;
        this.temperature = 0.5f;
        this.humidity = 0.5f;
        this.H = 0xFFFFFF;
        this.J = new ArrayList();
        this.K = new ArrayList();
        this.L = new ArrayList();
        this.S = true;
        this.N = new WorldGenTrees(false);
        this.O = new WorldGenBigTree(false);
        this.P = new WorldGenForest(false);
        this.Q = new WorldGenSwampTree();
        this.id = n;
        BiomeBase.biomes[n] = this;
        this.I = this.a();
        this.K.add(new BiomeMeta(EntitySheep.class, 12, 4, 4));
        this.K.add(new BiomeMeta(EntityPig.class, 10, 4, 4));
        this.K.add(new BiomeMeta(EntityChicken.class, 10, 4, 4));
        this.K.add(new BiomeMeta(EntityCow.class, 8, 4, 4));
        this.J.add(new BiomeMeta(EntitySpider.class, 10, 4, 4));
        this.J.add(new BiomeMeta(EntityZombie.class, 10, 4, 4));
        this.J.add(new BiomeMeta(EntitySkeleton.class, 10, 4, 4));
        this.J.add(new BiomeMeta(EntityCreeper.class, 10, 4, 4));
        this.J.add(new BiomeMeta(EntitySlime.class, 10, 4, 4));
        this.J.add(new BiomeMeta(EntityEnderman.class, 1, 1, 4));
        this.L.add(new BiomeMeta(EntitySquid.class, 10, 4, 4));
    }

    protected BiomeDecorator a() {
        return new BiomeDecorator(this);
    }

    private BiomeBase a(float f, float f2) {
        if (f > 0.1f && f < 0.2f) {
            throw new IllegalArgumentException("Please avoid temperatures in the range 0.1 - 0.2 because of snow");
        }
        this.temperature = f;
        this.humidity = f2;
        return this;
    }

    private BiomeBase b(float f, float f2) {
        this.D = f;
        this.E = f2;
        return this;
    }

    private BiomeBase m() {
        this.S = false;
        return this;
    }

    public WorldGenerator a(Random random) {
        if (random.nextInt(10) == 0) {
            return this.O;
        }
        return this.N;
    }

    public WorldGenerator b(Random random) {
        return new WorldGenGrass(Block.LONG_GRASS.id, 1);
    }

    protected BiomeBase b() {
        this.R = true;
        return this;
    }

    protected BiomeBase a(String string) {
        this.y = string;
        return this;
    }

    protected BiomeBase a(int n) {
        this.C = n;
        return this;
    }

    protected BiomeBase b(int n) {
        this.z = n;
        return this;
    }

    public List getMobs(EnumCreatureType enumCreatureType) {
        if (enumCreatureType == EnumCreatureType.MONSTER) {
            return this.J;
        }
        if (enumCreatureType == EnumCreatureType.CREATURE) {
            return this.K;
        }
        if (enumCreatureType == EnumCreatureType.WATER_CREATURE) {
            return this.L;
        }
        return null;
    }

    public boolean c() {
        return this.R;
    }

    public boolean d() {
        if (this.R) {
            return false;
        }
        return this.S;
    }

    public boolean e() {
        return this.humidity > 0.85f;
    }

    public float f() {
        return 0.1f;
    }

    public final int g() {
        return (int)(this.humidity * 65536.0f);
    }

    public final int h() {
        return (int)(this.temperature * 65536.0f);
    }

    public final float j() {
        return this.temperature;
    }

    public void a(World world, Random random, int n, int n2) {
        this.I.a(world, random, n, n2);
    }
}

