/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundByteHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.FileRegion;
import io.netty.channel.IncompleteFlushException;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.EncoderException;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;

public abstract class ByteToByteEncoder
extends ChannelOutboundByteHandlerAdapter {
    @Override
    protected void flush(ChannelHandlerContext ctx, ByteBuf in, ChannelPromise promise) throws Exception {
        ByteBuf out = ctx.nextOutboundByteBuffer();
        boolean encoded = false;
        while (in.isReadable()) {
            int oldInSize = in.readableBytes();
            try {
                this.encode(ctx, in, out);
                encoded = true;
            }
            catch (Throwable t) {
                Throwable cause = t instanceof CodecException ? t : new EncoderException(t);
                if (encoded) {
                    cause = new IncompleteFlushException("unable to encode all bytes", cause);
                }
                in.discardSomeReadBytes();
                promise.setFailure(cause);
                return;
            }
            if (oldInSize != in.readableBytes()) continue;
            break;
        }
        ctx.flush(promise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendFile(ChannelHandlerContext ctx, FileRegion region, ChannelPromise promise) throws Exception {
        block6: {
            long written = 0L;
            try {
                long localWritten;
                do {
                    if ((localWritten = region.transferTo(new BufferChannel(ctx.outboundByteBuffer()), written)) != -1L) continue;
                    ByteToByteEncoder.checkEOF(region, written);
                    this.flush(ctx, promise);
                    break block6;
                } while ((written += localWritten) < region.count());
                this.flush(ctx, promise);
            }
            catch (IOException e) {
                promise.setFailure(new EncoderException(e));
            }
            finally {
                region.release();
            }
        }
    }

    private static void checkEOF(FileRegion region, long writtenBytes) throws IOException {
        if (writtenBytes < region.count()) {
            throw new EOFException("Expected to be able to write " + region.count() + " bytes, but only wrote " + writtenBytes);
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, ByteBuf var2, ByteBuf var3) throws Exception;

    private static final class BufferChannel
    implements WritableByteChannel {
        private final ByteBuf buffer;

        BufferChannel(ByteBuf buffer) {
            this.buffer = buffer;
        }

        @Override
        public int write(ByteBuffer src) {
            int bytes = src.remaining();
            this.buffer.writeBytes(src);
            return bytes;
        }

        @Override
        public boolean isOpen() {
            return this.buffer.refCnt() > 0;
        }

        @Override
        public void close() {
        }
    }
}

