/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee.netty;

import io.netty.buffer.ByteBuf;
import java.beans.ConstructorProperties;
import javax.crypto.Cipher;
import javax.crypto.ShortBufferException;
import lombok.NonNull;

public class CipherBase {
    @NonNull
    private final Cipher cipher;
    private ThreadLocal<byte[]> heapInLocal = new EmptyByteThreadLocal();
    private ThreadLocal<byte[]> heapOutLocal = new EmptyByteThreadLocal();

    protected void cipher(ByteBuf in, ByteBuf out) throws ShortBufferException {
        int readableBytes;
        byte[] heapIn = this.heapInLocal.get();
        if (heapIn.length < (readableBytes = in.readableBytes())) {
            heapIn = new byte[readableBytes];
        }
        in.readBytes(heapIn, 0, readableBytes);
        byte[] heapOut = this.heapOutLocal.get();
        int outputSize = this.cipher.getOutputSize(readableBytes);
        if (heapOut.length < outputSize) {
            heapOut = new byte[outputSize];
        }
        out.writeBytes(heapOut, 0, this.cipher.update(heapIn, 0, readableBytes, heapOut));
    }

    @ConstructorProperties(value={"cipher"})
    protected CipherBase(@NonNull Cipher cipher) {
        if (cipher == null) {
            throw new NullPointerException("cipher");
        }
        this.cipher = cipher;
    }

    private static class EmptyByteThreadLocal
    extends ThreadLocal<byte[]> {
        private EmptyByteThreadLocal() {
        }

        @Override
        protected byte[] initialValue() {
            return new byte[0];
        }
    }
}

