/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundMessageHandlerAdapter;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.OutputMessageBuf;

public abstract class MessageToMessageDecoder<I>
extends ChannelInboundMessageHandlerAdapter<I> {
    protected MessageToMessageDecoder() {
    }

    protected MessageToMessageDecoder(Class<? extends I> inboundMessageType) {
        super(inboundMessageType);
    }

    @Override
    public final void messageReceived(ChannelHandlerContext ctx, I msg) throws Exception {
        OutputMessageBuf out = OutputMessageBuf.get();
        try {
            this.decode(ctx, msg, out);
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new DecoderException(cause);
        }
        finally {
            out.drainToNextInbound(ctx);
        }
    }

    protected abstract void decode(ChannelHandlerContext var1, I var2, MessageBuf<Object> var3) throws Exception;
}

