/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.api.connection.Server;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.protocol.packet.PacketFAPluginMessage;
import net.md_5.bungee.protocol.packet.PacketFFKick;

public class ServerConnection
implements Server {
    private final ChannelWrapper ch;
    private final BungeeServerInfo info;
    private boolean isObsolete;

    @Override
    public void sendData(String channel, byte[] data) {
        this.ch.write(new PacketFAPluginMessage(channel, data));
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (!this.ch.isClosed()) {
            this.ch.write(new PacketFFKick(reason));
            this.ch.getHandle().eventLoop().schedule(new Runnable(){

                @Override
                public void run() {
                    ServerConnection.this.ch.getHandle().close();
                }
            }, 100L, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public InetSocketAddress getAddress() {
        return this.getInfo().getAddress();
    }

    @ConstructorProperties(value={"ch", "info"})
    public ServerConnection(ChannelWrapper ch, BungeeServerInfo info) {
        this.ch = ch;
        this.info = info;
    }

    public ChannelWrapper getCh() {
        return this.ch;
    }

    @Override
    public BungeeServerInfo getInfo() {
        return this.info;
    }

    public boolean isObsolete() {
        return this.isObsolete;
    }

    public void setObsolete(boolean isObsolete) {
        this.isObsolete = isObsolete;
    }
}

