/*
 * Decompiled with CFR 0.152.
 */
package net.md_5.bungee;

import com.google.common.base.Preconditions;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.socket.nio.NioSocketChannel;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.logging.Level;
import lombok.NonNull;
import net.md_5.bungee.BungeeCord;
import net.md_5.bungee.BungeeServerInfo;
import net.md_5.bungee.ServerConnection;
import net.md_5.bungee.ServerConnector;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.config.ServerInfo;
import net.md_5.bungee.api.config.TexturePackInfo;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.event.PermissionCheckEvent;
import net.md_5.bungee.api.event.ServerConnectEvent;
import net.md_5.bungee.api.scoreboard.Scoreboard;
import net.md_5.bungee.connection.InitialHandler;
import net.md_5.bungee.netty.ChannelWrapper;
import net.md_5.bungee.netty.HandlerBoss;
import net.md_5.bungee.netty.PipelineUtils;
import net.md_5.bungee.packet.DefinedPacket;
import net.md_5.bungee.packet.Packet3Chat;
import net.md_5.bungee.packet.Packet9Respawn;
import net.md_5.bungee.packet.PacketCCSettings;
import net.md_5.bungee.packet.PacketFAPluginMessage;
import net.md_5.bungee.packet.PacketFFKick;

public final class UserConnection
implements ProxiedPlayer {
    @NonNull
    private final ProxyServer bungee;
    @NonNull
    private final ChannelWrapper ch;
    @NonNull
    private final String name;
    @NonNull
    private final InitialHandler pendingConnection;
    @NonNull
    private ServerConnection server = null;
    private final Object switchMutex = new Object();
    private final Collection<ServerInfo> pendingConnects = new HashSet<ServerInfo>();
    private int sentPingId;
    private long sentPingTime;
    private int ping = 100;
    private final Collection<String> groups = new HashSet<String>();
    private final Collection<String> permissions = new HashSet<String>();
    private int clientEntityId;
    private int serverEntityId;
    private PacketCCSettings settings;
    private final Scoreboard serverSentScoreboard = new Scoreboard();
    private String displayName;

    public void init() {
        this.displayName = this.name;
        Collection<String> g = this.bungee.getConfigurationAdapter().getGroups(this.name);
        for (String s : g) {
            this.addGroups(s);
        }
    }

    public void sendPacket(DefinedPacket p) {
        this.ch.write(p);
    }

    public void sendPacket(byte[] b) {
        this.ch.write(b);
    }

    @Deprecated
    public boolean isActive() {
        return this.ch.getHandle().isActive();
    }

    @Override
    public void setDisplayName(String name) {
        Preconditions.checkNotNull(name, "displayName");
        Preconditions.checkArgument(name.length() <= 16, "Display name cannot be longer than 16 characters");
        this.bungee.getTabListHandler().onDisconnect(this);
        this.displayName = name;
        this.bungee.getTabListHandler().onConnect(this);
    }

    @Override
    public void connect(ServerInfo target) {
        this.connect(target, false);
    }

    public void connectNow(ServerInfo target) {
        this.sendPacket(Packet9Respawn.DIM1_SWITCH);
        this.sendPacket(Packet9Respawn.DIM2_SWITCH);
        this.connect(target);
    }

    public void connect(ServerInfo info, final boolean retry) {
        ServerConnectEvent event = new ServerConnectEvent(this, info);
        if (this.bungee.getPluginManager().callEvent(event).isCancelled()) {
            return;
        }
        Preconditions.checkArgument(event.getTarget() instanceof BungeeServerInfo, "BungeeCord can only connect to BungeeServerInfo instances");
        final BungeeServerInfo target = (BungeeServerInfo)event.getTarget();
        if (this.getServer() != null && Objects.equals(this.getServer().getInfo(), target)) {
            this.sendMessage((Object)((Object)ChatColor.RED) + "Cannot connect to server you are already on!");
            return;
        }
        if (this.pendingConnects.contains(target)) {
            this.sendMessage((Object)((Object)ChatColor.RED) + "Already connecting to this server!");
            return;
        }
        this.pendingConnects.add(target);
        ChannelInitializer initializer = new ChannelInitializer(){

            protected void initChannel(Channel ch) throws Exception {
                PipelineUtils.BASE.initChannel(ch);
                ch.pipeline().get(HandlerBoss.class).setHandler(new ServerConnector(UserConnection.this.bungee, UserConnection.this, target));
            }
        };
        ChannelFutureListener listener = new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    future.channel().close();
                    UserConnection.this.pendingConnects.remove(target);
                    ServerInfo def = ProxyServer.getInstance().getServers().get(UserConnection.this.getPendingConnection().getListener().getFallbackServer());
                    if (retry & target != def && (UserConnection.this.getServer() == null || def != UserConnection.this.getServer().getInfo())) {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_lobby"));
                        UserConnection.this.connect(def, false);
                    } else if (UserConnection.this.server == null) {
                        UserConnection.this.disconnect(UserConnection.this.bungee.getTranslation("fallback_kick") + future.cause().getClass().getName());
                    } else {
                        UserConnection.this.sendMessage(UserConnection.this.bungee.getTranslation("fallback_kick") + future.cause().getClass().getName());
                    }
                }
            }
        };
        ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().channel(NioSocketChannel.class)).group(BungeeCord.getInstance().eventLoops)).handler(initializer)).localAddress(this.getPendingConnection().getListener().getHost())).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, 5000)).remoteAddress(target.getAddress()).connect().addListener(listener);
    }

    @Override
    public synchronized void disconnect(String reason) {
        if (this.ch.getHandle().isActive()) {
            this.bungee.getLogger().log(Level.INFO, "[" + this.getName() + "] disconnected with: " + reason);
            this.sendPacket(new PacketFFKick(reason));
            this.ch.getHandle().close();
            if (this.server != null) {
                this.server.disconnect("Quitting");
            }
        }
    }

    @Override
    public void chat(String message) {
        Preconditions.checkState(this.server != null, "Not connected to server");
        this.server.getCh().write(new Packet3Chat(message));
    }

    @Override
    public void sendMessage(String message) {
        this.sendPacket(new Packet3Chat(message));
    }

    @Override
    public void sendMessages(String ... messages) {
        for (String message : messages) {
            this.sendMessage(message);
        }
    }

    @Override
    public void sendData(String channel, byte[] data) {
        this.sendPacket(new PacketFAPluginMessage(channel, data));
    }

    @Override
    public InetSocketAddress getAddress() {
        return (InetSocketAddress)this.ch.getHandle().remoteAddress();
    }

    @Override
    public Collection<String> getGroups() {
        return Collections.unmodifiableCollection(this.groups);
    }

    @Override
    public void addGroups(String ... groups) {
        for (String group : groups) {
            this.groups.add(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, true);
            }
        }
    }

    @Override
    public void removeGroups(String ... groups) {
        for (String group : groups) {
            this.groups.remove(group);
            for (String permission : this.bungee.getConfigurationAdapter().getPermissions(group)) {
                this.setPermission(permission, false);
            }
        }
    }

    @Override
    public boolean hasPermission(String permission) {
        return this.bungee.getPluginManager().callEvent(new PermissionCheckEvent(this, permission, this.permissions.contains(permission))).hasPermission();
    }

    @Override
    public void setPermission(String permission, boolean value) {
        if (value) {
            this.permissions.add(permission);
        } else {
            this.permissions.remove(permission);
        }
    }

    public String toString() {
        return this.name;
    }

    public void setClientEntityId(int clientEntityId) {
        Preconditions.checkState(this.clientEntityId == 0, "Client entityId already set!");
        this.clientEntityId = clientEntityId;
    }

    @Override
    public void setTexturePack(TexturePackInfo pack) {
        this.sendPacket(new PacketFAPluginMessage("MC|TPack", (pack.getUrl() + "\u0000" + pack.getSize()).getBytes()));
    }

    @ConstructorProperties(value={"bungee", "ch", "name", "pendingConnection"})
    public UserConnection(@NonNull ProxyServer bungee, @NonNull ChannelWrapper ch, @NonNull String name, @NonNull InitialHandler pendingConnection) {
        if (bungee == null) {
            throw new NullPointerException("bungee");
        }
        if (ch == null) {
            throw new NullPointerException("ch");
        }
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (pendingConnection == null) {
            throw new NullPointerException("pendingConnection");
        }
        this.bungee = bungee;
        this.ch = ch;
        this.name = name;
        this.pendingConnection = pendingConnection;
    }

    @Override
    @NonNull
    public String getName() {
        return this.name;
    }

    @Override
    @NonNull
    public InitialHandler getPendingConnection() {
        return this.pendingConnection;
    }

    @Override
    @NonNull
    public ServerConnection getServer() {
        return this.server;
    }

    public void setServer(@NonNull ServerConnection server) {
        if (server == null) {
            throw new NullPointerException("server");
        }
        this.server = server;
    }

    public Object getSwitchMutex() {
        return this.switchMutex;
    }

    public Collection<ServerInfo> getPendingConnects() {
        return this.pendingConnects;
    }

    public int getSentPingId() {
        return this.sentPingId;
    }

    public void setSentPingId(int sentPingId) {
        this.sentPingId = sentPingId;
    }

    public long getSentPingTime() {
        return this.sentPingTime;
    }

    public void setSentPingTime(long sentPingTime) {
        this.sentPingTime = sentPingTime;
    }

    @Override
    public int getPing() {
        return this.ping;
    }

    public void setPing(int ping) {
        this.ping = ping;
    }

    public int getClientEntityId() {
        return this.clientEntityId;
    }

    public int getServerEntityId() {
        return this.serverEntityId;
    }

    public void setServerEntityId(int serverEntityId) {
        this.serverEntityId = serverEntityId;
    }

    public PacketCCSettings getSettings() {
        return this.settings;
    }

    public void setSettings(PacketCCSettings settings) {
        this.settings = settings;
    }

    public Scoreboard getServerSentScoreboard() {
        return this.serverSentScoreboard;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }
}

