/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.MessageBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundMessageHandlerAdapter;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.EncoderException;
import io.netty.handler.codec.OutputMessageBuf;

public abstract class MessageToMessageEncoder<I>
extends ChannelOutboundMessageHandlerAdapter<I> {
    protected MessageToMessageEncoder() {
    }

    protected MessageToMessageEncoder(Class<? extends I> outboundMessageType) {
        super(outboundMessageType);
    }

    @Override
    public final void flush(ChannelHandlerContext ctx, I msg) throws Exception {
        OutputMessageBuf out = OutputMessageBuf.get();
        try {
            this.encode(ctx, msg, out);
        }
        catch (CodecException e) {
            throw e;
        }
        catch (Throwable cause) {
            throw new EncoderException(cause);
        }
        finally {
            out.drainToNextOutbound(ctx);
        }
    }

    protected abstract void encode(ChannelHandlerContext var1, I var2, MessageBuf<Object> var3) throws Exception;
}

